/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanDraft;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.beans.Transient;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class AppServicePlanConfig {
    private String subscriptionId;
    private String resourceGroupName;
    private String name;
    private OperatingSystem os;
    private Region region;
    private PricingTier pricingTier;

    @Transient
    @Nullable
    public static AppServicePlan getAppServicePlan(@Nonnull AppServicePlanConfig config) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{config.getSubscriptionId(), config.getName(), config.getResourceGroupName()})) {
            return null;
        }
        AzureAppService az = (AzureAppService)Azure.az(AzureAppService.class);
        AppServicePlanDraft draft = (AppServicePlanDraft)az.plans(config.getSubscriptionId()).updateOrCreate(config.getName(), config.getResourceGroupName());
        draft.setOperatingSystem(config.getOs());
        draft.setRegion(config.getRegion());
        draft.setPricingTier(config.getPricingTier());
        return draft;
    }

    @Contract(value="null->null")
    public static AppServicePlanConfig fromResource(@Nullable AppServicePlan plan) {
        if (Objects.isNull((Object)plan)) {
            return null;
        }
        return AppServicePlanConfig.builder().subscriptionId(plan.getSubscriptionId()).resourceGroupName(plan.getResourceGroupName()).name(plan.getName()).os(plan.getOperatingSystem()).region(plan.getRegion()).pricingTier(plan.getPricingTier()).build();
    }

    @Nonnull
    public AppServicePlan toResource() {
        AppServicePlan plan = (AppServicePlan)((AzureAppService)Azure.az(AzureAppService.class)).plans(this.subscriptionId).getOrDraft(this.name, this.resourceGroupName);
        if (plan.isDraftForCreating()) {
            AppServicePlanDraft draft = (AppServicePlanDraft)plan;
            draft.setOperatingSystem(this.os);
            draft.setRegion(this.region);
            draft.setPricingTier(this.pricingTier);
        }
        return plan;
    }

    public static AppServicePlanConfigBuilder builder() {
        return new AppServicePlanConfigBuilder();
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public String getName() {
        return this.name;
    }

    public OperatingSystem getOs() {
        return this.os;
    }

    public Region getRegion() {
        return this.region;
    }

    public PricingTier getPricingTier() {
        return this.pricingTier;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOs(OperatingSystem os) {
        this.os = os;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setPricingTier(PricingTier pricingTier) {
        this.pricingTier = pricingTier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppServicePlanConfig)) {
            return false;
        }
        AppServicePlanConfig other = (AppServicePlanConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$subscriptionId = this.getSubscriptionId();
        String other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !this$subscriptionId.equals(other$subscriptionId)) {
            return false;
        }
        String this$resourceGroupName = this.getResourceGroupName();
        String other$resourceGroupName = other.getResourceGroupName();
        if (this$resourceGroupName == null ? other$resourceGroupName != null : !this$resourceGroupName.equals(other$resourceGroupName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        OperatingSystem this$os = this.getOs();
        OperatingSystem other$os = other.getOs();
        if (this$os == null ? other$os != null : !((Object)((Object)this$os)).equals((Object)other$os)) {
            return false;
        }
        Region this$region = this.getRegion();
        Region other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        PricingTier this$pricingTier = this.getPricingTier();
        PricingTier other$pricingTier = other.getPricingTier();
        return !(this$pricingTier == null ? other$pricingTier != null : !((Object)this$pricingTier).equals(other$pricingTier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppServicePlanConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : $subscriptionId.hashCode());
        String $resourceGroupName = this.getResourceGroupName();
        result = result * 59 + ($resourceGroupName == null ? 43 : $resourceGroupName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        OperatingSystem $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : ((Object)((Object)$os)).hashCode());
        Region $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        PricingTier $pricingTier = this.getPricingTier();
        result = result * 59 + ($pricingTier == null ? 43 : ((Object)$pricingTier).hashCode());
        return result;
    }

    public String toString() {
        return "AppServicePlanConfig(subscriptionId=" + this.getSubscriptionId() + ", resourceGroupName=" + this.getResourceGroupName() + ", name=" + this.getName() + ", os=" + (Object)((Object)this.getOs()) + ", region=" + this.getRegion() + ", pricingTier=" + this.getPricingTier() + ")";
    }

    public AppServicePlanConfig(String subscriptionId, String resourceGroupName, String name, OperatingSystem os, Region region, PricingTier pricingTier) {
        this.subscriptionId = subscriptionId;
        this.resourceGroupName = resourceGroupName;
        this.name = name;
        this.os = os;
        this.region = region;
        this.pricingTier = pricingTier;
    }

    public AppServicePlanConfig() {
    }

    public static class AppServicePlanConfigBuilder {
        private String subscriptionId;
        private String resourceGroupName;
        private String name;
        private OperatingSystem os;
        private Region region;
        private PricingTier pricingTier;

        AppServicePlanConfigBuilder() {
        }

        public AppServicePlanConfigBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public AppServicePlanConfigBuilder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public AppServicePlanConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AppServicePlanConfigBuilder os(OperatingSystem os) {
            this.os = os;
            return this;
        }

        public AppServicePlanConfigBuilder region(Region region) {
            this.region = region;
            return this;
        }

        public AppServicePlanConfigBuilder pricingTier(PricingTier pricingTier) {
            this.pricingTier = pricingTier;
            return this;
        }

        public AppServicePlanConfig build() {
            return new AppServicePlanConfig(this.subscriptionId, this.resourceGroupName, this.name, this.os, this.region, this.pricingTier);
        }

        public String toString() {
            return "AppServicePlanConfig.AppServicePlanConfigBuilder(subscriptionId=" + this.subscriptionId + ", resourceGroupName=" + this.resourceGroupName + ", name=" + this.name + ", os=" + (Object)((Object)this.os) + ", region=" + this.region + ", pricingTier=" + this.pricingTier + ")";
        }
    }
}

