/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.ListingContext;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public final class BaseRequest {
    private static final String METADATA = "metadata";
    private static final String SERVICE = "service";
    private static final String STATS = "stats";
    private static final String TIMEOUT = "timeout";
    private static String userAgent;

    public static void addMetadata(HttpURLConnection request, Map<String, String> metadata, OperationContext opContext) {
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                BaseRequest.addMetadata(request, entry.getKey(), entry.getValue(), opContext);
            }
        }
    }

    private static void addMetadata(HttpURLConnection request, String name, String value, OperationContext opContext) {
        if (Utility.isNullOrEmptyOrWhitespace(name)) {
            throw new IllegalArgumentException("The key for one of the metadata key-value pairs is null, empty, or whitespace.");
        }
        if (Utility.isNullOrEmptyOrWhitespace(value)) {
            throw new IllegalArgumentException("The value for one of the metadata key-value pairs is null, empty, or whitespace.");
        }
        request.setRequestProperty("x-ms-meta-" + name, value);
    }

    public static void addOptionalHeader(HttpURLConnection request, String name, String value) {
        if (value != null && !value.equals("")) {
            request.setRequestProperty(name, value);
        }
    }

    public static HttpURLConnection create(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection createURLConnection(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        if (options.getTimeoutIntervalInMs() != null && options.getTimeoutIntervalInMs() != 0) {
            builder.add(TIMEOUT, String.valueOf(options.getTimeoutIntervalInMs() / 1000));
        }
        URL resourceUrl = builder.addToURI(uri).toURL();
        Proxy proxy = OperationContext.getDefaultProxy();
        if (opContext != null && opContext.getProxy() != null) {
            proxy = opContext.getProxy();
        }
        HttpURLConnection retConnection = proxy != null ? (HttpURLConnection)resourceUrl.openConnection(proxy) : (HttpURLConnection)resourceUrl.openConnection();
        int timeout = Utility.getRemainingTimeout(options.getOperationExpiryTimeInMs(), options.getTimeoutIntervalInMs());
        retConnection.setReadTimeout(timeout);
        retConnection.setConnectTimeout(timeout);
        retConnection.setRequestProperty("Accept", "application/xml");
        retConnection.setRequestProperty("Accept-Charset", "UTF-8");
        retConnection.setRequestProperty("Content-Type", "");
        retConnection.setRequestProperty("x-ms-version", "2017-04-17");
        retConnection.setRequestProperty("User-Agent", BaseRequest.getUserAgent());
        retConnection.setRequestProperty("x-ms-client-request-id", opContext.getClientRequestID());
        return retConnection;
    }

    public static HttpURLConnection delete(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("DELETE");
        return retConnection;
    }

    public static UriQueryBuilder getListUriQueryBuilder(ListingContext listingContext) throws StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix());
            }
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
        }
        return builder;
    }

    public static HttpURLConnection getProperties(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("HEAD");
        return retConnection;
    }

    public static HttpURLConnection getServiceProperties(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    public static HttpURLConnection getServiceStats(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", STATS);
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    public static String getUserAgent() {
        if (userAgent == null) {
            String userAgentComment = String.format(Utility.LOCALE_US, "(JavaJRE %s; %s %s)", System.getProperty("java.version"), System.getProperty("os.name").replaceAll(" ", ""), System.getProperty("os.version"));
            userAgent = String.format("%s/%s %s", "Azure-Storage", "5.5.0", userAgentComment);
        }
        return userAgent;
    }

    public static HttpURLConnection setMetadata(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", METADATA);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection setServiceProperties(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    private BaseRequest() {
    }
}

