/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sqldb.spark.bulkcopy;

import com.microsoft.azure.sqldb.spark.bulkcopy.BulkCopyMetadata;
import com.microsoft.azure.sqldb.spark.bulkcopy.ColumnMetadata;
import com.microsoft.azure.sqldb.spark.bulkcopy.SQLServerExceptionReflection;
import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import java.sql.JDBCType;
import java.text.MessageFormat;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.Row;
import scala.collection.Iterator;

public class SQLServerBulkDataFrameFileRecord
implements ISQLServerBulkRecord,
AutoCloseable {
    private Iterator<Row> iterator;
    private Map<Integer, ColumnMetadata> columnMetadata;

    public SQLServerBulkDataFrameFileRecord(Iterator<Row> iterator, BulkCopyMetadata metadata) {
        this.iterator = iterator;
        this.columnMetadata = metadata.getMetadata();
    }

    public DateTimeFormatter getDateTimeFormatter(int column) {
        return this.columnMetadata.get(column).getDateTimeFormatter();
    }

    @Override
    public void close() throws SQLServerException {
    }

    public String getColumnName(int column) {
        return this.columnMetadata.get(column).getColumnName();
    }

    public Set<Integer> getColumnOrdinals() {
        return this.columnMetadata.keySet();
    }

    public int getColumnType(int column) {
        return this.columnMetadata.get(column).getColumnType();
    }

    public int getPrecision(int column) {
        return this.columnMetadata.get(column).getPrecision();
    }

    public Object[] getRowData() throws SQLServerException {
        Row row = (Row)this.iterator.next();
        Object[] rowData = new Object[row.length()];
        for (Map.Entry<Integer, ColumnMetadata> pair : this.columnMetadata.entrySet()) {
            ColumnMetadata cm = pair.getValue();
            try {
                switch (cm.getColumnType()) {
                    case 2013: 
                    case 2014: {
                        OffsetTime offsetTimeValue = cm.getDateTimeFormatter() != null ? OffsetTime.parse(row.get(pair.getKey() - 1).toString(), cm.getDateTimeFormatter()) : OffsetTime.parse(row.get(pair.getKey() - 1).toString());
                        rowData[pair.getKey().intValue() - 1] = offsetTimeValue;
                        break;
                    }
                    case 0: {
                        rowData[pair.getKey().intValue() - 1] = null;
                        break;
                    }
                    default: {
                        rowData[pair.getKey().intValue() - 1] = row.get(pair.getKey() - 1);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String value = "'" + row.get(pair.getKey() - 1) + "'";
                MessageFormat form = new MessageFormat(this.getSQLServerExceptionErrorMsg("R_errorConvertingValue"));
                String errText = form.format(new Object[]{value, JDBCType.valueOf(cm.getColumnType()).getName()});
                try {
                    throw SQLServerExceptionReflection.throwSQLServerException(errText, null, 0, illegalArgumentException);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(errText, illegalArgumentException);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayOutOfBoundsException) {
                String errText = this.getSQLServerExceptionErrorMsg("R_schemaMismatch");
                try {
                    throw SQLServerExceptionReflection.throwSQLServerException(errText, arrayOutOfBoundsException);
                }
                catch (Exception e) {
                    throw new ArrayIndexOutOfBoundsException(errText);
                }
            }
        }
        return rowData;
    }

    public int getScale(int column) {
        return this.columnMetadata.get(column).getScale();
    }

    public boolean isAutoIncrement(int column) {
        return false;
    }

    public boolean next() throws SQLServerException {
        return this.iterator.hasNext();
    }

    private String getSQLServerExceptionErrorMsg(String type) {
        return SQLServerResource.getBundle((String)"com.microsoft.sqlserver.jdbc.SQLServerResource").getString(type);
    }
}

