/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.schemaregistry.kafka.avro;

import com.azure.core.credential.TokenCredential;
import com.azure.core.models.MessageContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializerBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.microsoft.azure.schemaregistry.kafka.avro.KafkaAvroDeserializerConfig;
import java.util.Map;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaAvroDeserializer<T extends IndexedRecord>
implements Deserializer<T> {
    private SchemaRegistryApacheAvroSerializer serializer;
    private KafkaAvroDeserializerConfig config;

    public void configure(Map<String, ?> props, boolean isKey) {
        this.config = new KafkaAvroDeserializerConfig(props);
        TokenCredential tokenCredential = this.config.getCredential();
        if (tokenCredential == null) {
            if (this.config.createDefaultAzureCredential().booleanValue()) {
                tokenCredential = new DefaultAzureCredentialBuilder().build();
            } else {
                throw new RuntimeException("TokenCredential not created for serializer. Please provide a TokenCredential in config or set \"use.azure.credential\" to true.");
            }
        }
        this.serializer = new SchemaRegistryApacheAvroSerializerBuilder().schemaRegistryClient(new SchemaRegistryClientBuilder().fullyQualifiedNamespace(this.config.getSchemaRegistryUrl()).credential(tokenCredential).clientOptions(new ClientOptions().setApplicationId("java-avro-kafka-des-1.0")).buildAsyncClient()).avroSpecificReader(this.config.getAvroSpecificReader().booleanValue()).buildSerializer();
    }

    public T deserialize(String topic, byte[] bytes) {
        return null;
    }

    public T deserialize(String topic, Headers headers, byte[] bytes) {
        MessageContent message = new MessageContent();
        message.setBodyAsBinaryData(BinaryData.fromBytes((byte[])bytes));
        Header contentTypeHeader = headers.lastHeader("content-type");
        if (contentTypeHeader != null) {
            message.setContentType(new String(contentTypeHeader.value()));
        } else {
            message.setContentType("");
        }
        return (T)((IndexedRecord)this.serializer.deserialize(message, TypeReference.createInstance(this.config.getAvroSpecificType())));
    }

    public void close() {
    }
}

