/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.PolicyClientImpl;
import com.microsoft.azure.management.resources.implementation.PolicyDefinitionInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PolicyDefinitionsInner {
    private PolicyDefinitionsService service;
    private PolicyClientImpl client;

    public PolicyDefinitionsInner(Retrofit retrofit, PolicyClientImpl client) {
        this.service = (PolicyDefinitionsService)retrofit.create(PolicyDefinitionsService.class);
        this.client = client;
    }

    public PolicyDefinitionInner createOrUpdate(String policyDefinitionName, PolicyDefinitionInner parameters) {
        return (PolicyDefinitionInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(policyDefinitionName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyDefinitionInner> createOrUpdateAsync(String policyDefinitionName, PolicyDefinitionInner parameters, ServiceCallback<PolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(policyDefinitionName, parameters), serviceCallback);
    }

    public Observable<PolicyDefinitionInner> createOrUpdateAsync(String policyDefinitionName, PolicyDefinitionInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(policyDefinitionName, parameters).map((Func1)new Func1<ServiceResponse<PolicyDefinitionInner>, PolicyDefinitionInner>(){

            public PolicyDefinitionInner call(ServiceResponse<PolicyDefinitionInner> response) {
                return (PolicyDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyDefinitionInner>> createOrUpdateWithServiceResponseAsync(String policyDefinitionName, PolicyDefinitionInner parameters) {
        if (policyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2016-12-01";
        return this.service.createOrUpdate(policyDefinitionName, this.client.subscriptionId(), parameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicyDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyDefinitionsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyDefinitionInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<PolicyDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String policyDefinitionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(policyDefinitionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String policyDefinitionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(policyDefinitionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String policyDefinitionName) {
        return this.deleteWithServiceResponseAsync(policyDefinitionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String policyDefinitionName) {
        if (policyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.delete(policyDefinitionName, this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyDefinitionsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PolicyDefinitionInner get(String policyDefinitionName) {
        return (PolicyDefinitionInner)((ServiceResponse)this.getWithServiceResponseAsync(policyDefinitionName).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyDefinitionInner> getAsync(String policyDefinitionName, ServiceCallback<PolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(policyDefinitionName), serviceCallback);
    }

    public Observable<PolicyDefinitionInner> getAsync(String policyDefinitionName) {
        return this.getWithServiceResponseAsync(policyDefinitionName).map((Func1)new Func1<ServiceResponse<PolicyDefinitionInner>, PolicyDefinitionInner>(){

            public PolicyDefinitionInner call(ServiceResponse<PolicyDefinitionInner> response) {
                return (PolicyDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyDefinitionInner>> getWithServiceResponseAsync(String policyDefinitionName) {
        if (policyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.get(policyDefinitionName, this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicyDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyDefinitionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyDefinitionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicyDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PolicyDefinitionInner getBuiltIn(String policyDefinitionName) {
        return (PolicyDefinitionInner)((ServiceResponse)this.getBuiltInWithServiceResponseAsync(policyDefinitionName).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyDefinitionInner> getBuiltInAsync(String policyDefinitionName, ServiceCallback<PolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getBuiltInWithServiceResponseAsync(policyDefinitionName), serviceCallback);
    }

    public Observable<PolicyDefinitionInner> getBuiltInAsync(String policyDefinitionName) {
        return this.getBuiltInWithServiceResponseAsync(policyDefinitionName).map((Func1)new Func1<ServiceResponse<PolicyDefinitionInner>, PolicyDefinitionInner>(){

            public PolicyDefinitionInner call(ServiceResponse<PolicyDefinitionInner> response) {
                return (PolicyDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyDefinitionInner>> getBuiltInWithServiceResponseAsync(String policyDefinitionName) {
        if (policyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.getBuiltIn(policyDefinitionName, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicyDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyDefinitionsInner.this.getBuiltInDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyDefinitionInner> getBuiltInDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicyDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PolicyDefinitionInner createOrUpdateAtManagementGroup(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters) {
        return (PolicyDefinitionInner)((ServiceResponse)this.createOrUpdateAtManagementGroupWithServiceResponseAsync(policyDefinitionName, managementGroupId, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyDefinitionInner> createOrUpdateAtManagementGroupAsync(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters, ServiceCallback<PolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtManagementGroupWithServiceResponseAsync(policyDefinitionName, managementGroupId, parameters), serviceCallback);
    }

    public Observable<PolicyDefinitionInner> createOrUpdateAtManagementGroupAsync(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters) {
        return this.createOrUpdateAtManagementGroupWithServiceResponseAsync(policyDefinitionName, managementGroupId, parameters).map((Func1)new Func1<ServiceResponse<PolicyDefinitionInner>, PolicyDefinitionInner>(){

            public PolicyDefinitionInner call(ServiceResponse<PolicyDefinitionInner> response) {
                return (PolicyDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyDefinitionInner>> createOrUpdateAtManagementGroupWithServiceResponseAsync(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters) {
        if (policyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null.");
        }
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2016-12-01";
        return this.service.createOrUpdateAtManagementGroup(policyDefinitionName, managementGroupId, parameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicyDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyDefinitionsInner.this.createOrUpdateAtManagementGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyDefinitionInner> createOrUpdateAtManagementGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<PolicyDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAtManagementGroup(String policyDefinitionName, String managementGroupId) {
        ((ServiceResponse)this.deleteAtManagementGroupWithServiceResponseAsync(policyDefinitionName, managementGroupId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAtManagementGroupAsync(String policyDefinitionName, String managementGroupId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtManagementGroupWithServiceResponseAsync(policyDefinitionName, managementGroupId), serviceCallback);
    }

    public Observable<Void> deleteAtManagementGroupAsync(String policyDefinitionName, String managementGroupId) {
        return this.deleteAtManagementGroupWithServiceResponseAsync(policyDefinitionName, managementGroupId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtManagementGroupWithServiceResponseAsync(String policyDefinitionName, String managementGroupId) {
        if (policyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null.");
        }
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.deleteAtManagementGroup(policyDefinitionName, managementGroupId, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyDefinitionsInner.this.deleteAtManagementGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAtManagementGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PolicyDefinitionInner getAtManagementGroup(String policyDefinitionName, String managementGroupId) {
        return (PolicyDefinitionInner)((ServiceResponse)this.getAtManagementGroupWithServiceResponseAsync(policyDefinitionName, managementGroupId).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyDefinitionInner> getAtManagementGroupAsync(String policyDefinitionName, String managementGroupId, ServiceCallback<PolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtManagementGroupWithServiceResponseAsync(policyDefinitionName, managementGroupId), serviceCallback);
    }

    public Observable<PolicyDefinitionInner> getAtManagementGroupAsync(String policyDefinitionName, String managementGroupId) {
        return this.getAtManagementGroupWithServiceResponseAsync(policyDefinitionName, managementGroupId).map((Func1)new Func1<ServiceResponse<PolicyDefinitionInner>, PolicyDefinitionInner>(){

            public PolicyDefinitionInner call(ServiceResponse<PolicyDefinitionInner> response) {
                return (PolicyDefinitionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyDefinitionInner>> getAtManagementGroupWithServiceResponseAsync(String policyDefinitionName, String managementGroupId) {
        if (policyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null.");
        }
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.getAtManagementGroup(policyDefinitionName, managementGroupId, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyDefinitionInner>>>(){

            public Observable<ServiceResponse<PolicyDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyDefinitionsInner.this.getAtManagementGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyDefinitionInner> getAtManagementGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicyDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PolicyDefinitionInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<PolicyDefinitionInner>((Page)response.body()){

            public Page<PolicyDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyDefinitionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyDefinitionInner>> listAsync(ListOperationCallback<PolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(String nextPageLink) {
                return PolicyDefinitionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyDefinitionInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Page<PolicyDefinitionInner>>(){

            public Page<PolicyDefinitionInner> call(ServiceResponse<Page<PolicyDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(ServiceResponse<Page<PolicyDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyDefinitionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.list(this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyDefinitionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyDefinitionInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PolicyDefinitionInner> listBuiltIn() {
        ServiceResponse response = (ServiceResponse)this.listBuiltInSinglePageAsync().toBlocking().single();
        return new PagedList<PolicyDefinitionInner>((Page)response.body()){

            public Page<PolicyDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyDefinitionsInner.this.listBuiltInNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyDefinitionInner>> listBuiltInAsync(ListOperationCallback<PolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBuiltInSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(String nextPageLink) {
                return PolicyDefinitionsInner.this.listBuiltInNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyDefinitionInner>> listBuiltInAsync() {
        return this.listBuiltInWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Page<PolicyDefinitionInner>>(){

            public Page<PolicyDefinitionInner> call(ServiceResponse<Page<PolicyDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listBuiltInWithServiceResponseAsync() {
        return this.listBuiltInSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(ServiceResponse<Page<PolicyDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyDefinitionsInner.this.listBuiltInNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listBuiltInSinglePageAsync() {
        String apiVersion = "2016-12-01";
        return this.service.listBuiltIn("2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyDefinitionsInner.this.listBuiltInDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyDefinitionInner>> listBuiltInDelegate(Response<ResponseBody> response) throws CloudException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PolicyDefinitionInner> listByManagementGroup(String managementGroupId) {
        ServiceResponse response = (ServiceResponse)this.listByManagementGroupSinglePageAsync(managementGroupId).toBlocking().single();
        return new PagedList<PolicyDefinitionInner>((Page)response.body()){

            public Page<PolicyDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyDefinitionsInner.this.listByManagementGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyDefinitionInner>> listByManagementGroupAsync(String managementGroupId, ListOperationCallback<PolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByManagementGroupSinglePageAsync(managementGroupId), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(String nextPageLink) {
                return PolicyDefinitionsInner.this.listByManagementGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyDefinitionInner>> listByManagementGroupAsync(String managementGroupId) {
        return this.listByManagementGroupWithServiceResponseAsync(managementGroupId).map((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Page<PolicyDefinitionInner>>(){

            public Page<PolicyDefinitionInner> call(ServiceResponse<Page<PolicyDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listByManagementGroupWithServiceResponseAsync(String managementGroupId) {
        return this.listByManagementGroupSinglePageAsync(managementGroupId).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(ServiceResponse<Page<PolicyDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyDefinitionsInner.this.listByManagementGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listByManagementGroupSinglePageAsync(String managementGroupId) {
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.listByManagementGroup(managementGroupId, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyDefinitionsInner.this.listByManagementGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyDefinitionInner>> listByManagementGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PolicyDefinitionInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicyDefinitionInner>((Page)response.body()){

            public Page<PolicyDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyDefinitionsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyDefinitionInner>> listNextAsync(String nextPageLink, ServiceFuture<List<PolicyDefinitionInner>> serviceFuture, ListOperationCallback<PolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(String nextPageLink) {
                return PolicyDefinitionsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyDefinitionInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Page<PolicyDefinitionInner>>(){

            public Page<PolicyDefinitionInner> call(ServiceResponse<Page<PolicyDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(ServiceResponse<Page<PolicyDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyDefinitionsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyDefinitionsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyDefinitionInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PolicyDefinitionInner> listBuiltInNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listBuiltInNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicyDefinitionInner>((Page)response.body()){

            public Page<PolicyDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyDefinitionsInner.this.listBuiltInNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyDefinitionInner>> listBuiltInNextAsync(String nextPageLink, ServiceFuture<List<PolicyDefinitionInner>> serviceFuture, ListOperationCallback<PolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBuiltInNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(String nextPageLink) {
                return PolicyDefinitionsInner.this.listBuiltInNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyDefinitionInner>> listBuiltInNextAsync(String nextPageLink) {
        return this.listBuiltInNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Page<PolicyDefinitionInner>>(){

            public Page<PolicyDefinitionInner> call(ServiceResponse<Page<PolicyDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listBuiltInNextWithServiceResponseAsync(String nextPageLink) {
        return this.listBuiltInNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(ServiceResponse<Page<PolicyDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyDefinitionsInner.this.listBuiltInNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listBuiltInNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listBuiltInNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyDefinitionsInner.this.listBuiltInNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyDefinitionInner>> listBuiltInNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PolicyDefinitionInner> listByManagementGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByManagementGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicyDefinitionInner>((Page)response.body()){

            public Page<PolicyDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyDefinitionsInner.this.listByManagementGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyDefinitionInner>> listByManagementGroupNextAsync(String nextPageLink, ServiceFuture<List<PolicyDefinitionInner>> serviceFuture, ListOperationCallback<PolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByManagementGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(String nextPageLink) {
                return PolicyDefinitionsInner.this.listByManagementGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyDefinitionInner>> listByManagementGroupNextAsync(String nextPageLink) {
        return this.listByManagementGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Page<PolicyDefinitionInner>>(){

            public Page<PolicyDefinitionInner> call(ServiceResponse<Page<PolicyDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listByManagementGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByManagementGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyDefinitionInner>>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(ServiceResponse<Page<PolicyDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyDefinitionsInner.this.listByManagementGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> listByManagementGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByManagementGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyDefinitionsInner.this.listByManagementGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyDefinitionInner>> listByManagementGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PolicyDefinitionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="policyDefinitionName") String var1, @Path(value="subscriptionId") String var2, @Body PolicyDefinitionInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions delete"})
        @HTTP(path="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="policyDefinitionName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="policyDefinitionName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions getBuiltIn"})
        @GET(value="providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        public Observable<Response<ResponseBody>> getBuiltIn(@Path(value="policyDefinitionName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions createOrUpdateAtManagementGroup"})
        @PUT(value="providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        public Observable<Response<ResponseBody>> createOrUpdateAtManagementGroup(@Path(value="policyDefinitionName") String var1, @Path(value="managementGroupId") String var2, @Body PolicyDefinitionInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions deleteAtManagementGroup"})
        @HTTP(path="providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtManagementGroup(@Path(value="policyDefinitionName") String var1, @Path(value="managementGroupId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions getAtManagementGroup"})
        @GET(value="providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        public Observable<Response<ResponseBody>> getAtManagementGroup(@Path(value="policyDefinitionName") String var1, @Path(value="managementGroupId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions listBuiltIn"})
        @GET(value="providers/Microsoft.Authorization/policyDefinitions")
        public Observable<Response<ResponseBody>> listBuiltIn(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions listByManagementGroup"})
        @GET(value="providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions")
        public Observable<Response<ResponseBody>> listByManagementGroup(@Path(value="managementGroupId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions listBuiltInNext"})
        @GET
        public Observable<Response<ResponseBody>> listBuiltInNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyDefinitions listByManagementGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByManagementGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

