/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.utils;

import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.CloudError;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

public final class ProviderRegistrationInterceptor
implements Interceptor {
    private final AzureTokenCredentials credentials;

    public ProviderRegistrationInterceptor(AzureTokenCredentials credentials) {
        this.credentials = credentials;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String content;
        AzureJacksonAdapter jacksonAdapter;
        CloudError cloudError;
        Response response = chain.proceed(chain.request());
        if (!response.isSuccessful() && (cloudError = (CloudError)(jacksonAdapter = new AzureJacksonAdapter()).deserialize(content = this.errorBody(response.body()), CloudError.class)) != null && "MissingSubscriptionRegistration".equals(cloudError.code())) {
            Pattern pattern = Pattern.compile("/subscriptions/([\\w-]+)/", 2);
            Matcher matcher = pattern.matcher(chain.request().url().toString());
            matcher.find();
            RestClient restClient = new RestClient.Builder().withBaseUrl("https://" + chain.request().url().host()).withCredentials((ServiceClientCredentials)this.credentials).withSerializerAdapter((SerializerAdapter)jacksonAdapter).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).build();
            ResourceManager resourceManager = ResourceManager.authenticate(restClient).withSubscription(matcher.group(1));
            pattern = Pattern.compile(".*'(.*)'");
            matcher = pattern.matcher(cloudError.message());
            matcher.find();
            Provider provider = this.registerProvider(matcher.group(1), resourceManager);
            while (provider.registrationState().equalsIgnoreCase("Unregistered") || provider.registrationState().equalsIgnoreCase("Registering")) {
                SdkContext.sleep(5000);
                provider = (Provider)resourceManager.providers().getByName(provider.namespace());
            }
            response = chain.proceed(chain.request());
        }
        return response;
    }

    private String errorBody(ResponseBody responseBody) throws IOException {
        if (responseBody == null) {
            return null;
        }
        BufferedSource source = responseBody.source();
        source.request(Long.MAX_VALUE);
        Buffer buffer = source.buffer();
        return buffer.clone().readUtf8();
    }

    private Provider registerProvider(String namespace, ResourceManager resourceManager) {
        return resourceManager.providers().register(namespace);
    }
}

