/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.dag;

import com.microsoft.azure.management.resources.fluentcore.dag.DAGNode;
import com.microsoft.azure.management.resources.fluentcore.dag.Graph;
import com.microsoft.azure.management.resources.fluentcore.dag.Node;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DAGraph<DataT, NodeT extends DAGNode<DataT, NodeT>>
extends Graph<DataT, NodeT> {
    private ConcurrentLinkedQueue<String> queue;
    private boolean hasParent;
    private NodeT rootNode;

    public DAGraph(NodeT rootNode) {
        this.rootNode = rootNode;
        this.queue = new ConcurrentLinkedQueue();
        ((DAGNode)this.rootNode).setPreparer(true);
        this.addNode(rootNode);
    }

    public boolean hasParent() {
        return this.hasParent;
    }

    public boolean isRootNode(NodeT node) {
        return this.rootNode == node;
    }

    public boolean isPreparer() {
        return ((DAGNode)this.rootNode).isPreparer();
    }

    public void merge(DAGraph<DataT, NodeT> parent) {
        this.hasParent = true;
        ((DAGNode)parent.rootNode).addDependency(((Node)this.rootNode).key());
        for (Map.Entry entry : this.graph.entrySet()) {
            String key = (String)entry.getKey();
            if (parent.graph.containsKey(key)) continue;
            parent.graph.put(key, entry.getValue());
        }
    }

    public void mergeChildToParent(String parentKey, NodeT childNode) {
        DAGNode parentNode = (DAGNode)this.graph.get(parentKey);
        Map parentGraph = parentNode.owner().graph;
        Map childGraph = ((Node)childNode).owner().graph;
        for (Map.Entry entry : childGraph.entrySet()) {
            String key = entry.getKey();
            if (parentGraph.containsKey(key)) continue;
            parentGraph.put(key, entry.getValue());
        }
    }

    public void prepare() {
        if (this.isPreparer()) {
            for (DAGNode node : this.graph.values()) {
                node.initialize();
                if (this.isRootNode(node)) continue;
                node.setPreparer(false);
            }
            this.initializeDependentKeys();
            this.initializeQueue();
        }
    }

    public NodeT getNext() {
        String nextItemKey = this.queue.poll();
        if (nextItemKey == null) {
            return null;
        }
        return (NodeT)((DAGNode)this.graph.get(nextItemKey));
    }

    public NodeT getNode(String key) {
        return (NodeT)((DAGNode)this.graph.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCompletion(NodeT completed) {
        ((DAGNode)completed).setPreparer(true);
        String dependency = ((Node)completed).key();
        for (String dependentKey : ((DAGNode)this.graph.get(dependency)).dependentKeys()) {
            DAGNode dependent = (DAGNode)this.graph.get(dependentKey);
            dependent.lock().lock();
            try {
                dependent.onSuccessfulResolution(dependency);
                if (!dependent.hasAllResolved()) continue;
                this.queue.add(dependent.key());
            }
            finally {
                dependent.lock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportError(NodeT faulted, Throwable throwable) {
        ((DAGNode)faulted).setPreparer(true);
        String dependency = ((Node)faulted).key();
        for (String dependentKey : ((DAGNode)this.graph.get(dependency)).dependentKeys()) {
            DAGNode dependent = (DAGNode)this.graph.get(dependentKey);
            dependent.lock().lock();
            try {
                dependent.onFaultedResolution(dependency, throwable);
                if (!dependent.hasAllResolved()) continue;
                this.queue.add(dependent.key());
            }
            finally {
                dependent.lock().unlock();
            }
        }
    }

    private void initializeDependentKeys() {
        this.visit(new Graph.Visitor<NodeT>(){

            @Override
            public void visitNode(NodeT node) {
                if (((DAGNode)node).dependencyKeys().isEmpty()) {
                    return;
                }
                String dependentKey = ((Node)node).key();
                for (String dependencyKey : ((DAGNode)node).dependencyKeys()) {
                    ((DAGNode)DAGraph.this.graph.get(dependencyKey)).addDependent(dependentKey);
                }
            }

            @Override
            public void visitEdge(String fromKey, String toKey, Graph.EdgeType edgeType) {
                if (edgeType == Graph.EdgeType.BACK) {
                    throw new IllegalStateException("Detected circular dependency: " + DAGraph.this.findPath(fromKey, toKey));
                }
            }
        });
    }

    private void initializeQueue() {
        this.queue.clear();
        for (Map.Entry entry : this.graph.entrySet()) {
            if (((DAGNode)entry.getValue()).hasDependencies()) continue;
            this.queue.add((String)entry.getKey());
        }
        if (this.queue.isEmpty()) {
            throw new IllegalStateException("Detected circular dependency");
        }
    }
}

