/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.IPVersion;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerPublicFrontend;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NicIPConfiguration;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.PublicIPAddressDnsSettings;
import com.microsoft.azure.management.network.PublicIPSkuType;
import com.microsoft.azure.management.network.implementation.IPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.PublicIPAddressInner;
import com.microsoft.azure.management.resources.fluentcore.arm.AvailabilityZoneId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import rx.Observable;

@LangDefinition
class PublicIPAddressImpl
extends GroupableResourceImpl<PublicIPAddress, PublicIPAddressInner, PublicIPAddressImpl, NetworkManager>
implements PublicIPAddress,
PublicIPAddress.Definition,
PublicIPAddress.Update {
    PublicIPAddressImpl(String name, PublicIPAddressInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
    }

    protected Observable<PublicIPAddressInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).publicIPAddresses().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public PublicIPAddressImpl withIdleTimeoutInMinutes(int minutes) {
        ((PublicIPAddressInner)((Object)this.inner())).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    @Override
    public PublicIPAddressImpl withStaticIP() {
        ((PublicIPAddressInner)((Object)this.inner())).withPublicIPAllocationMethod(IPAllocationMethod.STATIC);
        return this;
    }

    @Override
    public PublicIPAddressImpl withDynamicIP() {
        ((PublicIPAddressInner)((Object)this.inner())).withPublicIPAllocationMethod(IPAllocationMethod.DYNAMIC);
        return this;
    }

    @Override
    public PublicIPAddressImpl withLeafDomainLabel(String dnsName) {
        ((PublicIPAddressInner)((Object)this.inner())).dnsSettings().withDomainNameLabel(dnsName == null ? null : dnsName.toLowerCase());
        return this;
    }

    @Override
    public PublicIPAddressImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((PublicIPAddressInner)((Object)this.inner())).zones() == null) {
            ((PublicIPAddressInner)((Object)this.inner())).withZones(new ArrayList<String>());
        }
        ((PublicIPAddressInner)((Object)this.inner())).zones().add(zoneId.toString());
        return this;
    }

    @Override
    public PublicIPAddressImpl withSku(PublicIPSkuType skuType) {
        ((PublicIPAddressInner)((Object)this.inner())).withSku(skuType.sku());
        return this;
    }

    @Override
    public PublicIPAddressImpl withoutLeafDomainLabel() {
        return this.withLeafDomainLabel(null);
    }

    @Override
    public PublicIPAddressImpl withReverseFqdn(String reverseFqdn) {
        ((PublicIPAddressInner)((Object)this.inner())).dnsSettings().withReverseFqdn(reverseFqdn != null ? reverseFqdn.toLowerCase() : null);
        return this;
    }

    @Override
    public PublicIPAddressImpl withoutReverseFqdn() {
        return this.withReverseFqdn(null);
    }

    @Override
    public int idleTimeoutInMinutes() {
        return Utils.toPrimitiveInt((Integer)((PublicIPAddressInner)((Object)this.inner())).idleTimeoutInMinutes());
    }

    @Override
    public IPAllocationMethod ipAllocationMethod() {
        return ((PublicIPAddressInner)((Object)this.inner())).publicIPAllocationMethod();
    }

    @Override
    public IPVersion version() {
        return ((PublicIPAddressInner)((Object)this.inner())).publicIPAddressVersion();
    }

    @Override
    public String fqdn() {
        if (((PublicIPAddressInner)((Object)this.inner())).dnsSettings() != null) {
            return ((PublicIPAddressInner)((Object)this.inner())).dnsSettings().fqdn();
        }
        return null;
    }

    @Override
    public String reverseFqdn() {
        if (((PublicIPAddressInner)((Object)this.inner())).dnsSettings() != null) {
            return ((PublicIPAddressInner)((Object)this.inner())).dnsSettings().reverseFqdn();
        }
        return null;
    }

    @Override
    public String ipAddress() {
        return ((PublicIPAddressInner)((Object)this.inner())).ipAddress();
    }

    @Override
    public String leafDomainLabel() {
        if (((PublicIPAddressInner)((Object)this.inner())).dnsSettings() == null) {
            return null;
        }
        return ((PublicIPAddressInner)((Object)this.inner())).dnsSettings().domainNameLabel();
    }

    public Observable<PublicIPAddress> createResourceAsync() {
        PublicIPAddressDnsSettings dnsSettings = ((PublicIPAddressInner)((Object)this.inner())).dnsSettings();
        if (!(dnsSettings == null || dnsSettings.domainNameLabel() != null && !dnsSettings.domainNameLabel().isEmpty() || dnsSettings.fqdn() != null && !dnsSettings.fqdn().isEmpty() || dnsSettings.reverseFqdn() != null && !dnsSettings.reverseFqdn().isEmpty())) {
            ((PublicIPAddressInner)((Object)this.inner())).withDnsSettings(null);
        }
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).publicIPAddresses().createOrUpdateAsync(this.resourceGroupName(), this.name(), (PublicIPAddressInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    private boolean equalsResourceType(String resourceType) {
        IPConfigurationInner ipConfig = ((PublicIPAddressInner)((Object)this.inner())).ipConfiguration();
        if (ipConfig == null || resourceType == null) {
            return false;
        }
        String refId = ((PublicIPAddressInner)((Object)this.inner())).ipConfiguration().id();
        String resourceType2 = ResourceUtils.resourceTypeFromResourceId((String)refId);
        return resourceType.equalsIgnoreCase(resourceType2);
    }

    @Override
    public boolean hasAssignedLoadBalancer() {
        return this.equalsResourceType("frontendIPConfigurations");
    }

    @Override
    public LoadBalancerPublicFrontend getAssignedLoadBalancerFrontend() {
        if (this.hasAssignedLoadBalancer()) {
            String refId = ((PublicIPAddressInner)((Object)this.inner())).ipConfiguration().id();
            String loadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)refId);
            LoadBalancer lb = (LoadBalancer)((NetworkManager)this.myManager).loadBalancers().getById(loadBalancerId);
            String frontendName = ResourceUtils.nameFromResourceId((String)refId);
            return (LoadBalancerPublicFrontend)lb.frontends().get(frontendName);
        }
        return null;
    }

    @Override
    public boolean hasAssignedNetworkInterface() {
        return this.equalsResourceType("ipConfigurations");
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((PublicIPAddressInner)((Object)this.inner())).zones() != null) {
            for (String zone : ((PublicIPAddressInner)((Object)this.inner())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public PublicIPSkuType sku() {
        return PublicIPSkuType.fromSku(((PublicIPAddressInner)((Object)this.inner())).sku());
    }

    @Override
    public NicIPConfiguration getAssignedNetworkInterfaceIPConfiguration() {
        if (this.hasAssignedNetworkInterface()) {
            String refId = ((PublicIPAddressInner)((Object)this.inner())).ipConfiguration().id();
            String parentId = ResourceUtils.parentResourceIdFromResourceId((String)refId);
            NetworkInterface nic = (NetworkInterface)((NetworkManager)this.myManager).networkInterfaces().getById(parentId);
            String childName = ResourceUtils.nameFromResourceId((String)refId);
            return nic.ipConfigurations().get(childName);
        }
        return null;
    }
}

