/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.IPVersion;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkInterface;
import com.microsoft.azure.management.network.NicIPConfiguration;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.BackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.InboundNatRuleInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NicIPConfigurationBaseImpl;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkInner;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@LangDefinition
class NicIPConfigurationImpl
extends NicIPConfigurationBaseImpl<NetworkInterfaceImpl, NetworkInterface>
implements NicIPConfiguration,
NicIPConfiguration.Definition<NetworkInterface.DefinitionStages.WithCreate>,
NicIPConfiguration.UpdateDefinition<NetworkInterface.Update>,
NicIPConfiguration.Update {
    private final NetworkManager networkManager;
    private final boolean isInCreateMode;
    private String creatableVirtualNetworkKey;
    private String creatablePublicIPKey;
    private Network existingVirtualNetworkToAssociate;
    private String existingPublicIPAddressIdToAssociate;
    private String subnetToAssociate;
    private boolean removePrimaryPublicIPAssociation;

    protected NicIPConfigurationImpl(NetworkInterfaceIPConfigurationInner inner, NetworkInterfaceImpl parent, NetworkManager networkManager, boolean isInCreateModel) {
        super(inner, parent, networkManager);
        this.isInCreateMode = isInCreateModel;
        this.networkManager = networkManager;
    }

    protected static NicIPConfigurationImpl prepareNicIPConfiguration(String name, NetworkInterfaceImpl parent, NetworkManager networkManager) {
        NetworkInterfaceIPConfigurationInner ipConfigurationInner = new NetworkInterfaceIPConfigurationInner();
        ipConfigurationInner.withName(name);
        return new NicIPConfigurationImpl(ipConfigurationInner, parent, networkManager, true);
    }

    @Override
    public String publicIPAddressId() {
        if (((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).publicIPAddress() == null) {
            return null;
        }
        return ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).publicIPAddress().id();
    }

    @Override
    public PublicIPAddress getPublicIPAddress() {
        String id = this.publicIPAddressId();
        if (id == null) {
            return null;
        }
        return (PublicIPAddress)this.networkManager.publicIPAddresses().getById(id);
    }

    public NetworkInterfaceImpl attach() {
        return ((NetworkInterfaceImpl)this.parent()).withIPConfiguration(this);
    }

    public NicIPConfigurationImpl withNewNetwork(Creatable<Network> creatable) {
        this.creatableVirtualNetworkKey = creatable.key();
        ((NetworkInterfaceImpl)this.parent()).addToCreatableDependencies(creatable);
        return this;
    }

    public NicIPConfigurationImpl withNewNetwork(String name, String addressSpaceCidr) {
        Network.DefinitionStages.WithGroup definitionWithGroup = (Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)this.networkManager.networks().define(name)).withRegion(((NetworkInterfaceImpl)this.parent()).regionName());
        Network.DefinitionStages.WithCreate definitionAfterGroup = ((NetworkInterfaceImpl)this.parent()).newGroup() != null ? (Network.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(((NetworkInterfaceImpl)this.parent()).newGroup()) : (Network.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(((NetworkInterfaceImpl)this.parent()).resourceGroupName());
        return this.withNewNetwork(definitionAfterGroup.withAddressSpace(addressSpaceCidr));
    }

    public NicIPConfigurationImpl withNewNetwork(String addressSpaceCidr) {
        return this.withNewNetwork(((NetworkInterfaceImpl)this.parent()).namer.randomName("vnet", 20), addressSpaceCidr);
    }

    public NicIPConfigurationImpl withExistingNetwork(Network network) {
        this.existingVirtualNetworkToAssociate = network;
        return this;
    }

    @Override
    public NicIPConfigurationImpl withPrivateIPAddressDynamic() {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAllocationMethod(IPAllocationMethod.DYNAMIC);
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(null);
        return this;
    }

    @Override
    public NicIPConfigurationImpl withPrivateIPAddressStatic(String staticPrivateIPAddress) {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAllocationMethod(IPAllocationMethod.STATIC);
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(staticPrivateIPAddress);
        return this;
    }

    @Override
    public NicIPConfigurationImpl withNewPublicIPAddress(Creatable<PublicIPAddress> creatable) {
        if (this.creatablePublicIPKey == null) {
            this.creatablePublicIPKey = creatable.key();
            ((NetworkInterfaceImpl)this.parent()).addToCreatableDependencies(creatable);
        }
        return this;
    }

    @Override
    public NicIPConfigurationImpl withNewPublicIPAddress() {
        String name = ((NetworkInterfaceImpl)this.parent()).namer.randomName("pip", 15);
        return this.withNewPublicIPAddress((Creatable)this.prepareCreatablePublicIP(name, name));
    }

    @Override
    public NicIPConfigurationImpl withNewPublicIPAddress(String leafDnsLabel) {
        return this.withNewPublicIPAddress((Creatable)this.prepareCreatablePublicIP(((NetworkInterfaceImpl)this.parent()).namer.randomName("pip", 15), leafDnsLabel));
    }

    @Override
    public NicIPConfigurationImpl withExistingPublicIPAddress(PublicIPAddress publicIPAddress) {
        return this.withExistingPublicIPAddress(publicIPAddress.id());
    }

    @Override
    public NicIPConfigurationImpl withExistingPublicIPAddress(String resourceId) {
        this.existingPublicIPAddressIdToAssociate = resourceId;
        return this;
    }

    @Override
    public NicIPConfigurationImpl withoutPublicIPAddress() {
        this.removePrimaryPublicIPAssociation = true;
        return this;
    }

    @Override
    public NicIPConfigurationImpl withSubnet(String name) {
        this.subnetToAssociate = name;
        return this;
    }

    @Override
    public NicIPConfigurationImpl withExistingLoadBalancerBackend(LoadBalancer loadBalancer, String backendName) {
        if (loadBalancer != null) {
            for (BackendAddressPoolInner pool : ((LoadBalancerInner)((Object)loadBalancer.inner())).backendAddressPools()) {
                if (!pool.name().equalsIgnoreCase(backendName)) continue;
                this.ensureLoadBalancerBackendAddressPools().add(pool);
                return this;
            }
        }
        return null;
    }

    @Override
    public NicIPConfigurationImpl withExistingApplicationGatewayBackend(ApplicationGateway appGateway, String backendName) {
        if (appGateway != null) {
            for (ApplicationGatewayBackendAddressPoolInner pool : ((ApplicationGatewayInner)((Object)appGateway.inner())).backendAddressPools()) {
                if (!pool.name().equalsIgnoreCase(backendName)) continue;
                this.ensureAppGatewayBackendAddressPools().add(pool);
                return this;
            }
        }
        return null;
    }

    @Override
    public NicIPConfigurationImpl withExistingLoadBalancerInboundNatRule(LoadBalancer loadBalancer, String inboundNatRuleName) {
        if (loadBalancer != null) {
            for (InboundNatRuleInner rule : ((LoadBalancerInner)((Object)loadBalancer.inner())).inboundNatRules()) {
                if (!rule.name().equalsIgnoreCase(inboundNatRuleName)) continue;
                this.ensureInboundNatRules().add(rule);
                return this;
            }
        }
        return null;
    }

    private List<ApplicationGatewayBackendAddressPoolInner> ensureAppGatewayBackendAddressPools() {
        List<ApplicationGatewayBackendAddressPoolInner> poolRefs = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).applicationGatewayBackendAddressPools();
        if (poolRefs == null) {
            poolRefs = new ArrayList<ApplicationGatewayBackendAddressPoolInner>();
            ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withApplicationGatewayBackendAddressPools(poolRefs);
        }
        return poolRefs;
    }

    private List<BackendAddressPoolInner> ensureLoadBalancerBackendAddressPools() {
        List<BackendAddressPoolInner> poolRefs = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).loadBalancerBackendAddressPools();
        if (poolRefs == null) {
            poolRefs = new ArrayList<BackendAddressPoolInner>();
            ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withLoadBalancerBackendAddressPools(poolRefs);
        }
        return poolRefs;
    }

    private List<InboundNatRuleInner> ensureInboundNatRules() {
        List<InboundNatRuleInner> natRefs = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).loadBalancerInboundNatRules();
        if (natRefs == null) {
            natRefs = new ArrayList<InboundNatRuleInner>();
            ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withLoadBalancerInboundNatRules(natRefs);
        }
        return natRefs;
    }

    protected static void ensureConfigurations(Collection<NicIPConfiguration> nicIPConfigurations) {
        for (NicIPConfiguration nicIPConfiguration : nicIPConfigurations) {
            NicIPConfigurationImpl config = (NicIPConfigurationImpl)nicIPConfiguration;
            ((NetworkInterfaceIPConfigurationInner)((Object)config.inner())).withSubnet(config.subnetToAssociate());
            ((NetworkInterfaceIPConfigurationInner)((Object)config.inner())).withPublicIPAddress(config.publicIPToAssociate());
        }
    }

    private Creatable<PublicIPAddress> prepareCreatablePublicIP(String name, String leafDnsLabel) {
        PublicIPAddress.DefinitionStages.WithGroup definitionWithGroup = (PublicIPAddress.DefinitionStages.WithGroup)((PublicIPAddress.DefinitionStages.Blank)this.networkManager.publicIPAddresses().define(name)).withRegion(((NetworkInterfaceImpl)this.parent()).regionName());
        PublicIPAddress.DefinitionStages.WithCreate definitionAfterGroup = ((NetworkInterfaceImpl)this.parent()).newGroup() != null ? (PublicIPAddress.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(((NetworkInterfaceImpl)this.parent()).newGroup()) : (PublicIPAddress.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(((NetworkInterfaceImpl)this.parent()).resourceGroupName());
        return definitionAfterGroup.withLeafDomainLabel(leafDnsLabel);
    }

    private SubnetInner subnetToAssociate() {
        SubnetInner subnetInner = new SubnetInner();
        if (this.isInCreateMode) {
            if (this.creatableVirtualNetworkKey != null) {
                Network network = (Network)((NetworkInterfaceImpl)this.parent()).createdDependencyResource(this.creatableVirtualNetworkKey);
                subnetInner.withId(((VirtualNetworkInner)((Object)network.inner())).subnets().get(0).id());
                return subnetInner;
            }
            for (SubnetInner subnet : ((VirtualNetworkInner)((Object)this.existingVirtualNetworkToAssociate.inner())).subnets()) {
                if (!subnet.name().equalsIgnoreCase(this.subnetToAssociate)) continue;
                subnetInner.withId(subnet.id());
                return subnetInner;
            }
            throw new RuntimeException("A subnet with name '" + this.subnetToAssociate + "' not found under the network '" + this.existingVirtualNetworkToAssociate.name() + "'");
        }
        if (this.subnetToAssociate != null) {
            int idx = ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).subnet().id().lastIndexOf(47);
            subnetInner.withId(((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).subnet().id().substring(0, idx + 1) + this.subnetToAssociate);
        } else {
            subnetInner.withId(((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).subnet().id());
        }
        return subnetInner;
    }

    private SubResource publicIPToAssociate() {
        String pipId = null;
        if (this.removePrimaryPublicIPAssociation) {
            return null;
        }
        if (this.creatablePublicIPKey != null) {
            pipId = ((PublicIPAddress)((NetworkInterfaceImpl)this.parent()).createdDependencyResource(this.creatablePublicIPKey)).id();
        } else if (this.existingPublicIPAddressIdToAssociate != null) {
            pipId = this.existingPublicIPAddressIdToAssociate;
        }
        if (pipId != null) {
            return new SubResource().withId(pipId);
        }
        if (!this.isInCreateMode) {
            return ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).publicIPAddress();
        }
        return null;
    }

    @Override
    public NicIPConfigurationImpl withPrivateIPVersion(IPVersion ipVersion) {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withPrivateIPAddressVersion(ipVersion);
        return this;
    }

    @Override
    public NicIPConfigurationImpl withoutApplicationGatewayBackends() {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withApplicationGatewayBackendAddressPools(null);
        return this;
    }

    @Override
    public NicIPConfigurationImpl withoutLoadBalancerBackends() {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withLoadBalancerBackendAddressPools(null);
        return this;
    }

    @Override
    public NicIPConfigurationImpl withoutLoadBalancerInboundNatRules() {
        ((NetworkInterfaceIPConfigurationInner)((Object)this.inner())).withLoadBalancerInboundNatRules(null);
        return this;
    }
}

