/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.NetworkSecurityRule;
import com.microsoft.azure.management.network.SecurityRuleAccess;
import com.microsoft.azure.management.network.SecurityRuleDirection;
import com.microsoft.azure.management.network.SecurityRuleProtocol;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupImpl;
import com.microsoft.azure.management.network.implementation.SecurityRuleInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;

@LangDefinition
class NetworkSecurityRuleImpl
extends ChildResourceImpl<SecurityRuleInner, NetworkSecurityGroupImpl, NetworkSecurityGroup>
implements NetworkSecurityRule,
NetworkSecurityRule.Definition<NetworkSecurityGroup.DefinitionStages.WithCreate>,
NetworkSecurityRule.UpdateDefinition<NetworkSecurityGroup.Update>,
NetworkSecurityRule.Update {
    NetworkSecurityRuleImpl(SecurityRuleInner inner, NetworkSecurityGroupImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((SecurityRuleInner)((Object)this.inner())).name();
    }

    @Override
    public SecurityRuleDirection direction() {
        return ((SecurityRuleInner)((Object)this.inner())).direction();
    }

    @Override
    public SecurityRuleProtocol protocol() {
        return ((SecurityRuleInner)((Object)this.inner())).protocol();
    }

    @Override
    public SecurityRuleAccess access() {
        return ((SecurityRuleInner)((Object)this.inner())).access();
    }

    @Override
    public String sourceAddressPrefix() {
        return ((SecurityRuleInner)((Object)this.inner())).sourceAddressPrefix();
    }

    @Override
    public String sourcePortRange() {
        return ((SecurityRuleInner)((Object)this.inner())).sourcePortRange();
    }

    @Override
    public String destinationAddressPrefix() {
        return ((SecurityRuleInner)((Object)this.inner())).destinationAddressPrefix();
    }

    @Override
    public String destinationPortRange() {
        return ((SecurityRuleInner)((Object)this.inner())).destinationPortRange();
    }

    @Override
    public int priority() {
        return Utils.toPrimitiveInt((Integer)((SecurityRuleInner)((Object)this.inner())).priority());
    }

    @Override
    public NetworkSecurityRuleImpl allowInbound() {
        return this.withDirection(SecurityRuleDirection.INBOUND).withAccess(SecurityRuleAccess.ALLOW);
    }

    @Override
    public NetworkSecurityRuleImpl allowOutbound() {
        return this.withDirection(SecurityRuleDirection.OUTBOUND).withAccess(SecurityRuleAccess.ALLOW);
    }

    @Override
    public NetworkSecurityRuleImpl denyInbound() {
        return this.withDirection(SecurityRuleDirection.INBOUND).withAccess(SecurityRuleAccess.DENY);
    }

    @Override
    public NetworkSecurityRuleImpl denyOutbound() {
        return this.withDirection(SecurityRuleDirection.OUTBOUND).withAccess(SecurityRuleAccess.DENY);
    }

    @Override
    public NetworkSecurityRuleImpl withProtocol(SecurityRuleProtocol protocol) {
        ((SecurityRuleInner)((Object)this.inner())).withProtocol(protocol);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withAnyProtocol() {
        return this.withProtocol(SecurityRuleProtocol.ASTERISK);
    }

    @Override
    public NetworkSecurityRuleImpl fromAddress(String cidr) {
        ((SecurityRuleInner)((Object)this.inner())).withSourceAddressPrefix(cidr);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromAnyAddress() {
        ((SecurityRuleInner)((Object)this.inner())).withSourceAddressPrefix("*");
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromPort(int port) {
        ((SecurityRuleInner)((Object)this.inner())).withSourcePortRange(String.valueOf(port));
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromAnyPort() {
        ((SecurityRuleInner)((Object)this.inner())).withSourcePortRange("*");
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromPortRange(int from, int to) {
        ((SecurityRuleInner)((Object)this.inner())).withSourcePortRange(String.valueOf(from) + "-" + String.valueOf(to));
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAddress(String cidr) {
        ((SecurityRuleInner)((Object)this.inner())).withDestinationAddressPrefix(cidr);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAnyAddress() {
        ((SecurityRuleInner)((Object)this.inner())).withDestinationAddressPrefix("*");
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toPort(int port) {
        ((SecurityRuleInner)((Object)this.inner())).withDestinationPortRange(String.valueOf(port));
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAnyPort() {
        ((SecurityRuleInner)((Object)this.inner())).withDestinationPortRange("*");
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toPortRange(int from, int to) {
        ((SecurityRuleInner)((Object)this.inner())).withDestinationPortRange(String.valueOf(from) + "-" + String.valueOf(to));
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withPriority(int priority) {
        if (priority < 100 || priority > 4096) {
            throw new IllegalArgumentException("The priority number of a network security rule must be between 100 and 4096.");
        }
        ((SecurityRuleInner)((Object)this.inner())).withPriority(priority);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withDescription(String description) {
        ((SecurityRuleInner)((Object)this.inner())).withDescription(description);
        return this;
    }

    private NetworkSecurityRuleImpl withDirection(SecurityRuleDirection direction) {
        ((SecurityRuleInner)((Object)this.inner())).withDirection(direction);
        return this;
    }

    private NetworkSecurityRuleImpl withAccess(SecurityRuleAccess permission) {
        ((SecurityRuleInner)((Object)this.inner())).withAccess(permission);
        return this;
    }

    public NetworkSecurityGroupImpl attach() {
        return ((NetworkSecurityGroupImpl)this.parent()).withRule(this);
    }

    @Override
    public String description() {
        return ((SecurityRuleInner)((Object)this.inner())).description();
    }
}

