/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.ProbeInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class LoadBalancerProbesInner {
    private LoadBalancerProbesService service;
    private NetworkManagementClientImpl client;

    public LoadBalancerProbesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (LoadBalancerProbesService)retrofit.create(LoadBalancerProbesService.class);
        this.client = client;
    }

    public PagedList<ProbeInner> list(String resourceGroupName, String loadBalancerName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, loadBalancerName).toBlocking().single();
        return new PagedList<ProbeInner>((Page)response.body()){

            public Page<ProbeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerProbesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProbeInner>> listAsync(String resourceGroupName, String loadBalancerName, ListOperationCallback<ProbeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, loadBalancerName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProbeInner>>>>(){

            public Observable<ServiceResponse<Page<ProbeInner>>> call(String nextPageLink) {
                return LoadBalancerProbesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProbeInner>> listAsync(String resourceGroupName, String loadBalancerName) {
        return this.listWithServiceResponseAsync(resourceGroupName, loadBalancerName).map((Func1)new Func1<ServiceResponse<Page<ProbeInner>>, Page<ProbeInner>>(){

            public Page<ProbeInner> call(ServiceResponse<Page<ProbeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProbeInner>>> listWithServiceResponseAsync(String resourceGroupName, String loadBalancerName) {
        return this.listSinglePageAsync(resourceGroupName, loadBalancerName).concatMap((Func1)new Func1<ServiceResponse<Page<ProbeInner>>, Observable<ServiceResponse<Page<ProbeInner>>>>(){

            public Observable<ServiceResponse<Page<ProbeInner>>> call(ServiceResponse<Page<ProbeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerProbesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProbeInner>>> listSinglePageAsync(String resourceGroupName, String loadBalancerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-08-01";
        return this.service.list(resourceGroupName, loadBalancerName, this.client.subscriptionId(), "2017-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProbeInner>>>>(){

            public Observable<ServiceResponse<Page<ProbeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerProbesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProbeInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProbeInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ProbeInner get(String resourceGroupName, String loadBalancerName, String probeName) {
        return (ProbeInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, probeName).toBlocking().single()).body());
    }

    public ServiceFuture<ProbeInner> getAsync(String resourceGroupName, String loadBalancerName, String probeName, ServiceCallback<ProbeInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, probeName), serviceCallback);
    }

    public Observable<ProbeInner> getAsync(String resourceGroupName, String loadBalancerName, String probeName) {
        return this.getWithServiceResponseAsync(resourceGroupName, loadBalancerName, probeName).map((Func1)new Func1<ServiceResponse<ProbeInner>, ProbeInner>(){

            public ProbeInner call(ServiceResponse<ProbeInner> response) {
                return (ProbeInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProbeInner>> getWithServiceResponseAsync(String resourceGroupName, String loadBalancerName, String probeName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (loadBalancerName == null) {
            throw new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null.");
        }
        if (probeName == null) {
            throw new IllegalArgumentException("Parameter probeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-08-01";
        return this.service.get(resourceGroupName, loadBalancerName, probeName, this.client.subscriptionId(), "2017-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProbeInner>>>(){

            public Observable<ServiceResponse<ProbeInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LoadBalancerProbesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProbeInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProbeInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProbeInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProbeInner>((Page)response.body()){

            public Page<ProbeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LoadBalancerProbesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProbeInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ProbeInner>> serviceFuture, ListOperationCallback<ProbeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProbeInner>>>>(){

            public Observable<ServiceResponse<Page<ProbeInner>>> call(String nextPageLink) {
                return LoadBalancerProbesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProbeInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ProbeInner>>, Page<ProbeInner>>(){

            public Page<ProbeInner> call(ServiceResponse<Page<ProbeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProbeInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ProbeInner>>, Observable<ServiceResponse<Page<ProbeInner>>>>(){

            public Observable<ServiceResponse<Page<ProbeInner>>> call(ServiceResponse<Page<ProbeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LoadBalancerProbesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProbeInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProbeInner>>>>(){

            public Observable<ServiceResponse<Page<ProbeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LoadBalancerProbesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProbeInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProbeInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LoadBalancerProbesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerProbes list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerProbes get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="loadBalancerName") String var2, @Path(value="probeName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.LoadBalancerProbes listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

