/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.keyvault.implementation.OperationsInner;
import com.microsoft.azure.management.keyvault.implementation.VaultsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class KeyVaultManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private VaultsInner vaults;
    private OperationsInner operations;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public KeyVaultManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public KeyVaultManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public KeyVaultManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public KeyVaultManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public VaultsInner vaults() {
        return this.vaults;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public KeyVaultManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public KeyVaultManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public KeyVaultManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2016-10-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.vaults = new VaultsInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "KeyVaultManagementClient", "2016-10-01");
    }
}

