/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.Galleries;
import com.microsoft.azure.management.compute.Gallery;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.GalleriesInner;
import com.microsoft.azure.management.compute.implementation.GalleryImpl;
import com.microsoft.azure.management.compute.implementation.GalleryInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.utils.RXMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class GalleriesImpl
extends GroupableResourcesImpl<Gallery, GalleryImpl, GalleryInner, GalleriesInner, ComputeManager>
implements Galleries {
    protected GalleriesImpl(ComputeManager manager) {
        super((Object)((ComputeManagementClientImpl)((Object)manager.inner())).galleries(), (ManagerBase)manager);
    }

    protected Observable<GalleryInner> getInnerAsync(String resourceGroupName, String name) {
        GalleriesInner client = (GalleriesInner)this.inner();
        return client.getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        GalleriesInner client = (GalleriesInner)this.inner();
        return client.deleteAsync(resourceGroupName, name).toCompletable();
    }

    public Observable<String> deleteByIdsAsync(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Observable.empty();
        }
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (String id : ids) {
            String resourceGroupName = ResourceUtils.groupFromResourceId((String)id);
            String name = ResourceUtils.nameFromResourceId((String)id);
            Observable o = RXMapper.map(((GalleriesInner)this.inner()).deleteAsync(resourceGroupName, name), (Object)id);
            observables.add(o);
        }
        return Observable.mergeDelayError(observables);
    }

    public Observable<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).toBlocking().last();
        }
    }

    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    public PagedList<Gallery> listByResourceGroup(String resourceGroupName) {
        GalleriesInner client = (GalleriesInner)this.inner();
        return this.wrapList(client.listByResourceGroup(resourceGroupName));
    }

    public Observable<Gallery> listByResourceGroupAsync(String resourceGroupName) {
        GalleriesInner client = (GalleriesInner)this.inner();
        return client.listByResourceGroupAsync(resourceGroupName).flatMapIterable((Func1)new Func1<Page<GalleryInner>, Iterable<GalleryInner>>(){

            public Iterable<GalleryInner> call(Page<GalleryInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<GalleryInner, Gallery>(){

            public Gallery call(GalleryInner inner) {
                return GalleriesImpl.this.wrapModel(inner);
            }
        });
    }

    public PagedList<Gallery> list() {
        GalleriesInner client = (GalleriesInner)this.inner();
        return this.wrapList(client.list());
    }

    public Observable<Gallery> listAsync() {
        GalleriesInner client = (GalleriesInner)this.inner();
        return client.listAsync().flatMapIterable((Func1)new Func1<Page<GalleryInner>, Iterable<GalleryInner>>(){

            public Iterable<GalleryInner> call(Page<GalleryInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<GalleryInner, Gallery>(){

            public Gallery call(GalleryInner inner) {
                return GalleriesImpl.this.wrapModel(inner);
            }
        });
    }

    public GalleryImpl define(String name) {
        return this.wrapModel(name);
    }

    protected GalleryImpl wrapModel(GalleryInner inner) {
        return new GalleryImpl(inner.name(), inner, (ComputeManager)this.manager());
    }

    protected GalleryImpl wrapModel(String name) {
        return new GalleryImpl(name, new GalleryInner(), (ComputeManager)this.manager());
    }
}

