/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.maven.utils.MavenUtils;
import com.microsoft.azure.maven.utils.XmlUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;

public class MavenConfigUtils {
    private static final String POM = "pom";
    private static final String JAR = "jar";
    private static final String DEFAULT_DIRECTORY = "${project.basedir}/target";
    private static final String DEFAULT_INCLUDE = "*.jar";

    public static boolean isPomPackaging(MavenProject mavenProject) {
        return POM.equalsIgnoreCase(mavenProject.getPackaging());
    }

    public static boolean isJarPackaging(MavenProject mavenProject) {
        return JAR.equalsIgnoreCase(mavenProject.getPackaging());
    }

    public static void addResourcesConfig(Element root, List<Resource> resources) {
        DOMElement resourceRootNode = new DOMElement("resources");
        for (Resource resource : resources) {
            DOMElement resourceNode = new DOMElement("resource");
            Optional.ofNullable(resource.getFiltering()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(value -> XmlUtils.addDomWithKeyValue((Element)resourceNode, "filtering", value));
            Optional.ofNullable(resource.getTargetPath()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(value -> XmlUtils.addDomWithKeyValue((Element)resourceNode, "targetPath", value));
            Optional.ofNullable(resource.getDirectory()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(value -> XmlUtils.addDomWithKeyValue((Element)resourceNode, "directory", value));
            Optional.ofNullable(resource.getIncludes()).filter(CollectionUtils::isNotEmpty).ifPresent(value -> XmlUtils.addDomWithValueList((Element)resourceNode, "includes", "include", value));
            Optional.ofNullable(resource.getExcludes()).filter(CollectionUtils::isNotEmpty).ifPresent(value -> XmlUtils.addDomWithValueList((Element)resourceNode, "excludes", "exclude", value));
            resourceRootNode.add((Element)resourceNode);
        }
        root.add((Element)resourceRootNode);
    }

    public static List<Resource> getDefaultResources() {
        Resource resource = new Resource();
        resource.setDirectory(DEFAULT_DIRECTORY);
        resource.addInclude(DEFAULT_INCLUDE);
        return Collections.singletonList(resource);
    }

    public static Xpp3Dom getPluginConfiguration(MavenProject proj, String pluginIdentifier) {
        return MavenUtils.getPluginConfiguration(proj, pluginIdentifier);
    }
}

