/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.maven.auth.MavenSettingHelper;
import com.microsoft.azure.maven.exception.MavenDecryptException;
import com.microsoft.azure.maven.model.MavenAuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.exception.InvalidConfigurationException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.auth.util.ValidationUtil;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.crypto.SettingsDecrypter;

public class MavenAuthUtils {
    private static final String INVALID_AZURE_ENVIRONMENT = "Invalid environment string '%s', please replace it with one of \"Azure\", \"AzureChina\", \"AzureGermany\", \"AzureUSGovernment\",.";

    public static AuthConfiguration buildAuthConfiguration(MavenSession session, SettingsDecrypter settingsDecrypter, @Nonnull MavenAuthConfiguration auth) throws AzureExecutionException, MavenDecryptException {
        AuthConfiguration authConfiguration;
        String serverId = auth.getServerId();
        try {
            authConfiguration = MavenAuthUtils.convertToAuthConfiguration(StringUtils.isNotBlank((CharSequence)auth.getServerId()) ? MavenSettingHelper.buildAuthConfigurationByServerId(session, settingsDecrypter, serverId) : auth);
        }
        catch (InvalidConfigurationException ex) {
            String messagePostfix = StringUtils.isNotBlank((CharSequence)serverId) ? "in server: '" + serverId + "' at maven settings.xml." : "in <auth> configuration.";
            throw new AzureExecutionException(String.format("%s %s", ex.getMessage(), messagePostfix));
        }
        return authConfiguration;
    }

    private static AuthConfiguration convertToAuthConfiguration(MavenAuthConfiguration mavenAuthConfiguration) throws InvalidConfigurationException {
        if (Objects.isNull(mavenAuthConfiguration)) {
            return new AuthConfiguration();
        }
        AuthConfiguration authConfiguration = new AuthConfiguration();
        authConfiguration.setClient(mavenAuthConfiguration.getClient());
        authConfiguration.setTenant(mavenAuthConfiguration.getTenant());
        authConfiguration.setCertificate(mavenAuthConfiguration.getCertificate());
        authConfiguration.setCertificatePassword(mavenAuthConfiguration.getCertificatePassword());
        authConfiguration.setKey(mavenAuthConfiguration.getKey());
        String authTypeStr = mavenAuthConfiguration.getType();
        authConfiguration.setType(AuthType.parseAuthType((String)authTypeStr));
        authConfiguration.setEnvironment(AzureEnvironmentUtils.stringToAzureEnvironment((String)mavenAuthConfiguration.getEnvironment()));
        if (StringUtils.isNotBlank((CharSequence)mavenAuthConfiguration.getEnvironment()) && Objects.isNull(authConfiguration.getEnvironment())) {
            throw new InvalidConfigurationException(String.format(INVALID_AZURE_ENVIRONMENT, mavenAuthConfiguration.getEnvironment()));
        }
        if (StringUtils.isBlank((CharSequence)mavenAuthConfiguration.getType())) {
            if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{mavenAuthConfiguration.getCertificate(), mavenAuthConfiguration.getKey(), mavenAuthConfiguration.getCertificatePassword()})) {
                ValidationUtil.validateAuthConfiguration((AuthConfiguration)authConfiguration);
            }
        } else if (authConfiguration.getType() == AuthType.SERVICE_PRINCIPAL) {
            ValidationUtil.validateAuthConfiguration((AuthConfiguration)authConfiguration);
        }
        return authConfiguration;
    }

    public static void disableIdentityLogs() {
        MavenAuthUtils.putPropertyIfNotExist("org.slf4j.simpleLogger.log.com.azure.identity", "off");
        MavenAuthUtils.putPropertyIfNotExist("org.slf4j.simpleLogger.log.com.microsoft.aad.adal4j", "off");
        MavenAuthUtils.putPropertyIfNotExist("org.slf4j.simpleLogger.log.com.azure.core.credential", "off");
        MavenAuthUtils.putPropertyIfNotExist("org.slf4j.simpleLogger.log.com.microsoft.aad.msal4jextensions", "off");
    }

    private static void putPropertyIfNotExist(String key, String value) {
        if (StringUtils.isBlank((CharSequence)System.getProperty(key))) {
            System.setProperty(key, value);
        }
    }
}

