/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public class CustomTextIoStringListReader<T>
extends GenericInputReader<T> {
    private String customPrompt;

    public CustomTextIoStringListReader(Supplier<TextTerminal<?>> textTerminalSupplier, Function<String, InputReader.ParseResult<T>> parser) {
        super(textTerminalSupplier, parser);
    }

    public InputReader<T, GenericInputReader<T>> withCustomPrompt(String customPrompt) {
        this.customPrompt = customPrompt;
        return this;
    }

    protected void printPrompt(List<String> prompt, TextTerminal<?> textTerminal) {
        textTerminal.print(prompt);
        boolean useColon = false;
        if (this.promptAdjustments && prompt != null && !prompt.isEmpty()) {
            String lastLine = prompt.get(prompt.size() - 1);
            useColon = CustomTextIoStringListReader.anotherShouldAppendColon(lastLine);
        }
        if (this.possibleValues == null) {
            if (this.promptAdjustments && this.defaultValue != null) {
                textTerminal.print(" [" + (String)this.valueFormatter.apply(this.defaultValue) + "]: ");
            } else {
                textTerminal.print(useColon ? ": " : " ");
            }
        } else if (this.promptAdjustments) {
            int optionCount = this.possibleValues.size();
            if (this.inlinePossibleValues) {
                String strValues = IntStream.range(0, optionCount).mapToObj(i -> this.possibleValues.get(i)).map(option -> {
                    boolean isDefault = this.defaultValue != null && (Boolean)this.equalsFunc.apply(this.defaultValue, option) != false;
                    return (isDefault ? "*" : "") + (String)this.valueFormatter.apply(option);
                }).collect(Collectors.joining(", ", " (", "): "));
                textTerminal.print(strValues);
            } else {
                textTerminal.println(useColon ? ":" : "");
                String defaultOptionText = null;
                for (int i2 = 0; i2 < optionCount; ++i2) {
                    Object option2 = this.possibleValues.get(i2);
                    boolean isDefault = this.defaultValue != null && (Boolean)this.equalsFunc.apply(this.defaultValue, option2) != false;
                    String optionId = "";
                    String optionText = (String)this.valueFormatter.apply(option2);
                    if (this.numberedPossibleValues) {
                        int digits = ("" + optionCount).length();
                        optionId = String.format("%" + digits + "d: ", i2 + 1);
                        String[] textLines = optionText.split("\\R", -1);
                        if (textLines.length > 1) {
                            String delimiter = String.format("\n%" + (digits + 4) + "s", "");
                            optionText = Arrays.stream(textLines).collect(Collectors.joining(delimiter));
                        }
                    }
                    if (isDefault) {
                        defaultOptionText = optionId + optionText;
                        textTerminal.println(TextUtils.blue((String)("* " + optionId + optionText)));
                        continue;
                    }
                    textTerminal.println("  " + optionId + optionText);
                }
                if (StringUtils.isNotBlank((CharSequence)this.customPrompt)) {
                    textTerminal.print(this.customPrompt);
                } else {
                    textTerminal.print(String.format("Enter your choice%s: ", StringUtils.isNotBlank(defaultOptionText) ? String.format("[%s]", TextUtils.blue(defaultOptionText)) : ""));
                }
            }
        }
    }

    private static boolean anotherShouldAppendColon(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        char lastChar = s.charAt(s.length() - 1);
        return "()[]{}".indexOf(lastChar) > 0 || Character.isJavaIdentifierPart(lastChar);
    }
}

