/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.messagesecurity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.keyvault.messagesecurity.JWSHeader;
import com.microsoft.azure.keyvault.messagesecurity.MessageSecurityHelper;
import java.io.IOException;
import java.util.Objects;

class JWSObject {
    private JWSHeader jwsHeader;
    private String originalProtected;
    private String payload;
    private String signature;

    JWSObject(JWSHeader jwsHeader, String payload, String signature) {
        this.jwsHeader = jwsHeader;
        this.payload = payload;
        this.signature = signature;
    }

    @JsonCreator
    JWSObject(@JsonProperty(value="protected") String jwsHeaderB64, @JsonProperty(value="payload") String payload, @JsonProperty(value="signature") String signature) throws Exception {
        this.jwsHeader = JWSHeader.fromBase64String(jwsHeaderB64);
        this.originalProtected = jwsHeaderB64;
        this.payload = payload;
        this.signature = signature;
    }

    public boolean equals(JWSObject other) {
        return this.payload.equals(other.payload) && this.jwsHeader.equals(other.jwsHeader) && this.signature.equals(other.signature);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.jwsHeader, this.signature);
    }

    public String serialize() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static JWSObject deserialize(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JWSObject)mapper.readValue(json, JWSObject.class);
    }

    public JWSHeader jwsHeader() {
        return this.jwsHeader;
    }

    public String originalProtected() {
        return this.originalProtected;
    }

    @JsonProperty(value="protected")
    public String protectedB64() throws Exception {
        return MessageSecurityHelper.stringToBase64Url(this.jwsHeader.serialize());
    }

    @JsonProperty(value="payload")
    public String payload() {
        return this.payload;
    }

    @JsonProperty(value="signature")
    public String signature() {
        return this.signature;
    }
}

