/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.CommandHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.CommandHandlerImpl;
import com.microsoft.azure.toolkit.lib.legacy.function.utils.CommandUtils;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="run")
public class RunMojo
extends AbstractFunctionMojo {
    protected static final String FUNC_CMD = "func -v";
    protected static final String FUNC_HOST_START_CMD = "func host start";
    protected static final String RUN_FUNCTIONS_FAILURE = "Failed to run Azure Functions. Please checkout console output.";
    protected static final String RUNTIME_NOT_FOUND = "Azure Functions Core Tools not found. Please go to https://aka.ms/azfunc-install to install Azure Functions Core Tools first.";
    private static final String STAGE_DIR_FOUND = "Azure Function App's staging directory found at: ";
    private static final String STAGE_DIR_NOT_FOUND = "Stage directory not found. Please run mvn package first.";
    private static final String RUNTIME_FOUND = "Azure Functions Core Tools found.";
    private static final String FUNC_HOST_START_WITH_DEBUG_CMD = "func host start --language-worker -- \"-agentlib:jdwp=%s\"";
    private static final ComparableVersion JAVA_9 = new ComparableVersion("9");
    private static final ComparableVersion FUNC_3 = new ComparableVersion("3");
    private static final ComparableVersion MINIMUM_JAVA_9_SUPPORTED_VERSION = new ComparableVersion("3.0.2630");
    private static final ComparableVersion MINIMUM_JAVA_9_SUPPORTED_VERSION_V2 = new ComparableVersion("2.7.2628");
    private static final String FUNC_VERSION_CMD = "func -v";
    private static final String FUNCTION_CORE_TOOLS_OUT_OF_DATE = "Local function core tools didn't support java 9 or higher runtime, to update it, see: https://aka.ms/azfunc-install.";
    @Parameter(property="localDebugConfig", defaultValue="transport=dt_socket,server=y,suspend=n,address=5005")
    protected String localDebugConfig;

    public String getLocalDebugConfig() {
        return this.localDebugConfig;
    }

    public void setLocalDebugConfig(String localDebugConfig) {
        this.localDebugConfig = localDebugConfig;
    }

    protected void doExecute() throws AzureExecutionException {
        this.validateAppName();
        CommandHandlerImpl commandHandler = new CommandHandlerImpl();
        this.checkStageDirectoryExistence();
        this.checkRuntimeExistence((CommandHandler)commandHandler);
        this.checkRuntimeCompatibility((CommandHandler)commandHandler);
        this.runFunctions((CommandHandler)commandHandler);
    }

    protected void checkStageDirectoryExistence() throws AzureExecutionException {
        File file = new File(this.getDeploymentStagingDirectoryPath());
        if (!file.exists() || !file.isDirectory()) {
            throw new AzureExecutionException(STAGE_DIR_NOT_FOUND);
        }
        Log.info((String)(STAGE_DIR_FOUND + this.getDeploymentStagingDirectoryPath()));
    }

    protected void checkRuntimeExistence(CommandHandler handler) throws AzureExecutionException {
        handler.runCommandWithReturnCodeCheck(this.getCheckRuntimeCommand(), true, null, CommandUtils.getDefaultValidReturnCodes(), RUNTIME_NOT_FOUND);
        Log.info((String)RUNTIME_FOUND);
    }

    protected void runFunctions(CommandHandler handler) throws AzureExecutionException {
        handler.runCommandWithReturnCodeCheck(this.getStartFunctionHostCommand(), true, this.getDeploymentStagingDirectoryPath(), CommandUtils.getValidReturnCodes(), RUN_FUNCTIONS_FAILURE);
    }

    private void checkRuntimeCompatibility(CommandHandler handler) throws AzureExecutionException {
        ComparableVersion minimumVersion;
        ComparableVersion javaVersion = new ComparableVersion(System.getProperty("java.version"));
        if (javaVersion.compareTo(JAVA_9) < 0) {
            return;
        }
        ComparableVersion funcVersion = new ComparableVersion(handler.runCommandAndGetOutput("func -v", false, null));
        ComparableVersion comparableVersion = minimumVersion = funcVersion.compareTo(FUNC_3) >= 0 ? MINIMUM_JAVA_9_SUPPORTED_VERSION : MINIMUM_JAVA_9_SUPPORTED_VERSION_V2;
        if (funcVersion.compareTo(minimumVersion) < 0) {
            throw new AzureExecutionException(FUNCTION_CORE_TOOLS_OUT_OF_DATE);
        }
    }

    protected String getCheckRuntimeCommand() {
        return "func -v";
    }

    protected String getStartFunctionHostCommand() {
        String enableDebug = System.getProperty("enableDebug");
        if (StringUtils.isNotEmpty((CharSequence)enableDebug) && enableDebug.equalsIgnoreCase("true")) {
            return this.getStartFunctionHostWithDebugCommand();
        }
        return FUNC_HOST_START_CMD;
    }

    protected String getStartFunctionHostWithDebugCommand() {
        return String.format(FUNC_HOST_START_WITH_DEBUG_CMD, this.getLocalDebugConfig());
    }
}

