/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.appservice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.exception.MavenDecryptException;
import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAppServiceMojo
extends AbstractAzureMojo {
    private static final Logger log = LoggerFactory.getLogger(AbstractAppServiceMojo.class);
    protected static final String MAVEN_PLUGIN_POSTFIX = "-maven-plugin";
    @JsonProperty
    @Parameter(property="resourceGroup", required=false)
    protected String resourceGroup;
    @JsonProperty
    @Parameter(property="appName", required=false)
    protected String appName;
    @JsonProperty
    @Parameter(property="appServicePlanResourceGroup")
    protected String appServicePlanResourceGroup;
    @JsonProperty
    @Parameter(property="appServicePlanName")
    protected String appServicePlanName;
    @JsonProperty(value="deploymentSlot")
    @Parameter(alias="deploymentSlot")
    protected DeploymentSlotSetting deploymentSlotSetting;
    @JsonProperty
    @Parameter
    protected Properties appSettings;
    @JsonIgnore
    protected AzureAppService appServiceClient;

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    public Map getAppSettings() {
        if (this.appSettings == null) {
            this.appSettings = new Properties();
        }
        return this.appSettings;
    }

    public List<DeploymentResource> getResources() {
        return Collections.emptyList();
    }

    public String getDeploymentStagingDirectoryPath() {
        String outputFolder = this.getPluginName().replaceAll(MAVEN_PLUGIN_POSTFIX, "");
        return Paths.get(this.getBuildDirectoryAbsolutePath(), outputFolder, this.getAppName()).toString();
    }

    protected AzureAppService initAzureAppServiceClient() {
        if (this.appServiceClient == null) {
            try {
                Account account = this.loginAzure();
                List subscriptions = account.getSubscriptions();
                String targetSubscriptionId = this.getTargetSubscriptionId(this.getSubscriptionId(), subscriptions, account.getSelectedSubscriptions());
                AbstractAzureMojo.checkSubscription((List)subscriptions, (String)targetSubscriptionId);
                ((AzureAccount)Azure.az(AzureAccount.class)).account().setSelectedSubscriptions(Collections.singletonList(targetSubscriptionId));
                this.appServiceClient = (AzureAppService)Azure.az(AzureAppService.class);
                this.printCurrentSubscription(this.appServiceClient);
                this.subscriptionId = targetSubscriptionId;
            }
            catch (MavenDecryptException | AzureExecutionException | IOException e) {
                throw new AzureToolkitRuntimeException("Cannot authenticate", e);
            }
        }
        return this.appServiceClient;
    }

    protected void printCurrentSubscription(AzureAppService appServiceClient) {
        if (appServiceClient == null) {
            return;
        }
        List subscriptions = ((IAzureAccount)Azure.az(IAzureAccount.class)).account().getSelectedSubscriptions();
        Subscription subscription = (Subscription)subscriptions.get(0);
        if (subscription != null) {
            log.info(String.format("Subscription: %s(%s)", TextUtils.cyan((String)subscription.getName()), TextUtils.cyan((String)subscription.getId())));
        }
    }

    public DeploymentSlotSetting getDeploymentSlotSetting() {
        return this.deploymentSlotSetting;
    }
}

