/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.boot.dependencies.apachecommons.io.filefilter;

import com.microsoft.applicationinsights.boot.dependencies.apachecommons.io.FileUtils;
import com.microsoft.applicationinsights.boot.dependencies.apachecommons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.io.Serializable;
import java.util.Date;

public class AgeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -2132740084016138541L;
    private final long cutoff;
    private final boolean acceptOlder;

    public AgeFileFilter(long cutoff) {
        this(cutoff, true);
    }

    public AgeFileFilter(long cutoff, boolean acceptOlder) {
        this.acceptOlder = acceptOlder;
        this.cutoff = cutoff;
    }

    public AgeFileFilter(Date cutoffDate) {
        this(cutoffDate, true);
    }

    public AgeFileFilter(Date cutoffDate, boolean acceptOlder) {
        this(cutoffDate.getTime(), acceptOlder);
    }

    public AgeFileFilter(File cutoffReference) {
        this(cutoffReference, true);
    }

    public AgeFileFilter(File cutoffReference, boolean acceptOlder) {
        this(cutoffReference.lastModified(), acceptOlder);
    }

    @Override
    public boolean accept(File file) {
        boolean newer = FileUtils.isFileNewer(file, this.cutoff);
        return this.acceptOlder ? !newer : newer;
    }

    @Override
    public String toString() {
        String condition = this.acceptOlder ? "<=" : ">";
        return super.toString() + "(" + condition + this.cutoff + ")";
    }
}

