/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.DbAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.ErrorAttributes;

abstract class DbClientCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends DbClientCommonAttributesGetter<REQUEST, RESPONSE>>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<String> DB_NAME = AttributeKey.stringKey("db.name");
    static final AttributeKey<String> DB_SYSTEM = AttributeKey.stringKey("db.system");
    private static final AttributeKey<String> DB_USER = AttributeKey.stringKey("db.user");
    private static final AttributeKey<String> DB_CONNECTION_STRING = AttributeKey.stringKey("db.connection_string");
    final GETTER getter;

    DbClientCommonAttributesExtractor(GETTER getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_SYSTEM_NAME, SemconvStability.stableDbSystemName(this.getter.getDbSystem(request)));
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_NAMESPACE, this.getter.getDbNamespace(request));
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DB_SYSTEM, this.getter.getDbSystem(request));
            AttributesExtractorUtil.internalSet(attributes, DB_USER, this.getter.getUser(request));
            AttributesExtractorUtil.internalSet(attributes, DB_NAME, this.getter.getDbNamespace(request));
            AttributesExtractorUtil.internalSet(attributes, DB_CONNECTION_STRING, this.getter.getConnectionString(request));
        }
    }

    @Override
    public final void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            if (error != null) {
                AttributesExtractorUtil.internalSet(attributes, ErrorAttributes.ERROR_TYPE, error.getClass().getName());
            }
            if (error != null || response != null) {
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_RESPONSE_STATUS_CODE, this.getter.getResponseStatus(response, error));
            }
        }
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

