/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import com.microsoft.applicationinsights.agent.shadow.javax.annotation.concurrent.Immutable;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributeType;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.internal.InternalExtendedAttributeKeyImpl;
import java.util.List;

@Immutable
public interface ExtendedAttributeKey<T> {
    public String getKey();

    public ExtendedAttributeType getType();

    @Nullable
    default public AttributeKey<T> asAttributeKey() {
        return InternalExtendedAttributeKeyImpl.toAttributeKey(this);
    }

    public static <T> ExtendedAttributeKey<T> fromAttributeKey(AttributeKey<T> attributeKey) {
        return InternalExtendedAttributeKeyImpl.toExtendedAttributeKey(attributeKey);
    }

    public static ExtendedAttributeKey<String> stringKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.stringKey(key));
    }

    public static ExtendedAttributeKey<Boolean> booleanKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.booleanKey(key));
    }

    public static ExtendedAttributeKey<Long> longKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.longKey(key));
    }

    public static ExtendedAttributeKey<Double> doubleKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.doubleKey(key));
    }

    public static ExtendedAttributeKey<List<String>> stringArrayKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.stringArrayKey(key));
    }

    public static ExtendedAttributeKey<List<Boolean>> booleanArrayKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.booleanArrayKey(key));
    }

    public static ExtendedAttributeKey<List<Long>> longArrayKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.longArrayKey(key));
    }

    public static ExtendedAttributeKey<List<Double>> doubleArrayKey(String key) {
        return ExtendedAttributeKey.fromAttributeKey(AttributeKey.doubleArrayKey(key));
    }

    public static ExtendedAttributeKey<ExtendedAttributes> extendedAttributesKey(String key) {
        return InternalExtendedAttributeKeyImpl.create(key, ExtendedAttributeType.EXTENDED_ATTRIBUTES);
    }
}

