/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.spring;

import com.mendmix.common.CurrentRuntimeContext;
import com.mendmix.common.model.AuthUser;
import com.mendmix.common.util.ResourceUtils;
import com.mendmix.mybatis.MybatisRuntimeContext;
import com.mendmix.mybatis.plugin.rewrite.annotation.DataPermission;
import com.mendmix.mybatis.plugin.rewrite.annotation.RewriteIgnore;
import com.mendmix.mybatis.plugin.rewrite.annotation.SofeDeleteIgnore;
import com.mendmix.mybatis.plugin.rewrite.annotation.TenantIgnore;
import com.mendmix.mybatis.plugin.rwseparate.UseMaster;
import com.mendmix.spring.InterceptorHanlder;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class MyBatisInterceptorHanlder
implements InterceptorHanlder {
    private List<String> ignoreTenantUserTypes = ResourceUtils.getList((String)"mendmix.mybatis.tenant.ignoreUserType");

    public void preHandler(Method method, Object[] args) {
        if (!MybatisRuntimeContext.isTransactionalOn() && method.isAnnotationPresent(Transactional.class)) {
            MybatisRuntimeContext.setTransactionalMode(true);
        }
        if (method.isAnnotationPresent(UseMaster.class)) {
            MybatisRuntimeContext.forceUseMaster();
        }
        if (method.isAnnotationPresent(TenantIgnore.class)) {
            MybatisRuntimeContext.setIgnoreTenant(true);
        } else {
            AuthUser currentUser = CurrentRuntimeContext.getCurrentUser();
            if (currentUser != null && this.ignoreTenantUserTypes.contains(currentUser.getType())) {
                MybatisRuntimeContext.setIgnoreTenant(true);
            }
        }
        if (method.isAnnotationPresent(DataPermission.class)) {
            MybatisRuntimeContext.setDataPermissionStrategy(method.getAnnotation(DataPermission.class));
        }
        if (method.isAnnotationPresent(RewriteIgnore.class)) {
            MybatisRuntimeContext.setIgnoreSqlRewrite(true);
        }
        if (method.isAnnotationPresent(SofeDeleteIgnore.class)) {
            MybatisRuntimeContext.setIgnoreSoftDeleteConditon(true);
        }
    }

    public void postHandler(Method method, Object result, Exception ex) {
    }

    public void destory() {
    }
}

