/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.spring;

import com.mendmix.mybatis.MybatisConfigs;
import com.mendmix.mybatis.crud.GeneralSqlGenerator;
import com.mendmix.mybatis.metadata.MapperMetadata;
import com.mendmix.mybatis.parser.MybatisMapperParser;
import com.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MendmixMybatisEnhancer {
    private static final Logger logger = LoggerFactory.getLogger(MendmixMybatisEnhancer.class);

    public static void handle(String group, Configuration configuration) throws Exception {
        try {
            Class<?> helperClazz = Class.forName("tk.mybatis.mapper.mapperhelper.MapperHelper");
            Object helper = helperClazz.newInstance();
            Class<?> configClazz = Class.forName("tk.mybatis.mapper.entity.Config");
            Object config = configClazz.newInstance();
            Method method = configClazz.getDeclaredMethod("setNotEmpty", Boolean.TYPE);
            method.invoke(config, false);
            method = helperClazz.getDeclaredMethod("setConfig", configClazz);
            method.invoke(helper, config);
            method = helperClazz.getDeclaredMethod("registerMapper", Class.class);
            List<MapperMetadata> mappers = MybatisMapperParser.getMapperMetadatas(group);
            for (MapperMetadata mapper : mappers) {
                method.invoke(helper, mapper.getMapperClass());
            }
            method = helperClazz.getDeclaredMethod("processConfiguration", Configuration.class);
            method.invoke(helper, configuration);
        }
        catch (ClassNotFoundException e) {
            new GeneralSqlGenerator(group, configuration).generate();
        }
        catch (Exception e) {
            throw e;
        }
        try {
            Class<?> pageHelperClazz = Class.forName("com.github.pagehelper.PageInterceptor");
            Interceptor pageInterceptor = (Interceptor)pageHelperClazz.newInstance();
            configuration.addInterceptor(pageInterceptor);
        }
        catch (Exception pageHelperClazz) {
            // empty catch block
        }
        String[] hanlderNames = MybatisConfigs.getHandlerNames(group);
        MendmixMybatisInterceptor interceptor = new MendmixMybatisInterceptor(group, hanlderNames);
        configuration.addInterceptor((Interceptor)interceptor);
        interceptor.afterRegister();
        logger.info("MENDMIX-TRACE-LOGGGING-->> JeesuiteMybatisEnhancer finshed -> group:{},hanlderNames:{}", (Object)group, (Object)hanlderNames);
    }
}

