/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin.shard;

import com.mendmix.mybatis.core.InterceptorHandler;
import com.mendmix.mybatis.metadata.MapperMetadata;
import com.mendmix.mybatis.parser.MybatisMapperParser;
import com.mendmix.mybatis.plugin.InvocationVals;
import com.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRouteHandler
implements InterceptorHandler {
    protected static final Logger logger = LoggerFactory.getLogger(TableRouteHandler.class);
    private List<String> tableRouteMappedStatements = new ArrayList<String>();

    @Override
    public void start(MendmixMybatisInterceptor context) {
        List<MapperMetadata> mappers = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        ArrayList<String> tmpTables = new ArrayList<String>();
        for (MapperMetadata mapper : mappers) {
            if (!mapper.getTableName().contains("${")) continue;
            tmpTables.add(mapper.getTableName());
        }
        for (MapperMetadata mapper : mappers) {
            if (tmpTables.contains(mapper.getTableName())) {
                this.tableRouteMappedStatements.add(mapper.getMapperClass().getName());
                continue;
            }
            Set<String> querys = mapper.getQueryTableMappings().keySet();
            block2: for (String query : querys) {
                List<String> tables = mapper.getQueryTableMappings().get(query);
                for (String table : tables) {
                    if (!tmpTables.contains(table)) continue;
                    this.tableRouteMappedStatements.add(query);
                    continue block2;
                }
            }
        }
    }

    @Override
    public Object onInterceptor(InvocationVals invocation) throws Throwable {
        return null;
    }

    @Override
    public void onFinished(InvocationVals invocation, Object result) {
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 0;
    }
}

