/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin.rewrite;

import com.mendmix.mybatis.plugin.rewrite.annotation.DataPermission;
import com.mendmix.mybatis.plugin.rewrite.annotation.TablePermissionStrategy;
import java.util.HashMap;
import java.util.Map;

public class SqlRewriteStrategy {
    private boolean ignoreAny;
    private boolean ignoreTenant;
    private boolean ignoreSoftDelete;
    private boolean ignoreColumnPerm;
    private boolean allMatch = true;
    private boolean handleOrderBy = true;
    private boolean handleJoin = true;
    private Map<String, TablePermissionStrategy> tableStrategies;

    public void setDataPermission(DataPermission annotation) {
        this.ignoreColumnPerm = annotation.ignore();
        this.handleJoin = annotation.handleJoin();
        if (annotation.strategy().length > 0) {
            this.allMatch = false;
            this.tableStrategies = new HashMap<String, TablePermissionStrategy>(annotation.strategy().length);
            for (TablePermissionStrategy policy : annotation.strategy()) {
                this.tableStrategies.put(policy.table(), policy);
            }
        }
    }

    public SqlRewriteStrategy(boolean allMatch, Map<String, TablePermissionStrategy> strategies) {
        this.allMatch = allMatch;
        this.tableStrategies = strategies;
    }

    public boolean isIgnoreAny() {
        return this.ignoreAny;
    }

    public void setIgnoreAny(boolean ignoreAny) {
        this.ignoreAny = ignoreAny;
    }

    public boolean isAllMatch() {
        return this.allMatch;
    }

    public boolean isIgnoreTenant() {
        return this.ignoreTenant;
    }

    public void setIgnoreTenant(boolean ignoreTenant) {
        this.ignoreTenant = ignoreTenant;
    }

    public boolean isIgnoreSoftDelete() {
        return this.ignoreSoftDelete;
    }

    public void setIgnoreSoftDelete(boolean ignoreSoftDelete) {
        this.ignoreSoftDelete = ignoreSoftDelete;
    }

    public boolean isIgnoreColumnPerm() {
        return this.ignoreColumnPerm;
    }

    public void setIgnoreColumnPerm(boolean ignoreColumnPerm) {
        this.ignoreColumnPerm = ignoreColumnPerm;
    }

    public boolean isHandleOrderBy() {
        return this.handleOrderBy;
    }

    public void setHandleOrderBy(boolean handleOrderBy) {
        this.handleOrderBy = handleOrderBy;
    }

    public TablePermissionStrategy getTableStrategy(String table) {
        if (this.tableStrategies == null) {
            return null;
        }
        return this.tableStrategies.get(table);
    }

    public boolean hasTableStrategy(String table) {
        if (this.tableStrategies == null) {
            return false;
        }
        return this.tableStrategies.containsKey(table);
    }

    public boolean handleOwner(String table) {
        if (this.allMatch) {
            return this.allMatch;
        }
        return this.tableStrategies.containsKey(table) ? this.getTableStrategy(table).handleOwner() : true;
    }

    public boolean isHandleJoin() {
        return this.handleJoin;
    }
}

