/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin.rewrite;

import com.mendmix.common.CurrentRuntimeContext;
import com.mendmix.common.MendmixBaseException;
import com.mendmix.common.model.AuthUser;
import com.mendmix.common.model.OrderBy;
import com.mendmix.common.model.PageParams;
import com.mendmix.common.util.JsonUtils;
import com.mendmix.common.util.ResourceUtils;
import com.mendmix.common.util.StringConverter;
import com.mendmix.mybatis.MybatisConfigs;
import com.mendmix.mybatis.MybatisRuntimeContext;
import com.mendmix.mybatis.core.InterceptorHandler;
import com.mendmix.mybatis.crud.CrudMethods;
import com.mendmix.mybatis.metadata.ColumnMetadata;
import com.mendmix.mybatis.metadata.MapperMetadata;
import com.mendmix.mybatis.parser.MybatisMapperParser;
import com.mendmix.mybatis.plugin.InvocationVals;
import com.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import com.mendmix.mybatis.plugin.rewrite.SqlRewriteStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperation;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.UnionOp;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRewriteHandler
implements InterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.mendmix.mybatis");
    public static final String FRCH_PREFIX = "__frch_";
    private static final String FRCH_INDEX_PREFIX = "__frch_index_";
    private static final String FRCH_ITEM_PREFIX = "__frch_item_";
    private static final String QUERY_FUZZY_CHAR = "%";
    private static boolean dynaDataPermEnaled = false;
    private Map<String, String> globalDataPermColumnMappings = new HashMap<String, String>();
    private Map<String, LinkedHashMap<String, String>> tableDataPermColumnMappings = new HashMap<String, LinkedHashMap<String, String>>();
    private List<String> softDeleteMappedStatements = new ArrayList<String>();
    private String softDeleteColumnName;
    private String softDeletePropName;
    private String softDeleteFalseValue;
    private boolean columnSharddingTenant;
    private String tenantColumnName;
    private String tenantPropName;
    private String orgBasePermKey;
    private String deptColumnName;
    private String deptPropName;
    private String ownerColumnName;
    private List<String> deptMappedStatements = new ArrayList<String>();

    @Override
    public void start(MendmixMybatisInterceptor context) {
        dynaDataPermEnaled = MybatisConfigs.isDataPermissionEnabled(context.getGroupName());
        this.columnSharddingTenant = MybatisConfigs.isColumnSharddingTenant(context.getGroupName());
        this.softDeleteColumnName = MybatisConfigs.getSoftDeleteColumn(context.getGroupName());
        this.softDeleteFalseValue = MybatisConfigs.getSoftDeletedFalseValue(context.getGroupName());
        this.deptColumnName = MybatisConfigs.getDeptColumnName(context.getGroupName());
        this.ownerColumnName = MybatisConfigs.getOwnerColumnName(context.getGroupName());
        this.orgBasePermKey = MybatisConfigs.getCurrentOrgPermKey(context.getGroupName());
        List<MapperMetadata> mappers = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        if (dynaDataPermEnaled) {
            Properties properties = ResourceUtils.getAllProperties((String)"mendmix.mybatis.dataPermission.columns");
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String tableName = null;
                if (k.toString().contains("[")) {
                    tableName = k.toString().substring(k.toString().indexOf("[") + 1).replace("]", "").trim();
                }
                this.buildTableDataPermColumnMapping(tableName, v.toString());
            }));
            for (MapperMetadata mapper : mappers) {
                Collection<String> columns = mapper.getPropToColumnMappings().values();
                Optional<Map.Entry> optional = this.globalDataPermColumnMappings.entrySet().stream().filter(e -> columns.contains(e.getValue())).findFirst();
                if (!optional.isPresent()) continue;
                if (!this.tableDataPermColumnMappings.containsKey(mapper.getTableName())) {
                    this.tableDataPermColumnMappings.put(mapper.getTableName(), new LinkedHashMap());
                }
                this.tableDataPermColumnMappings.get(mapper.getTableName()).put((String)optional.get().getKey(), (String)optional.get().getValue());
            }
        }
        this.initColumnConfig(mappers, this.deptColumnName, this.deptMappedStatements);
        this.initColumnConfig(mappers, this.softDeleteColumnName, this.softDeleteMappedStatements);
        if (this.columnSharddingTenant) {
            this.tenantColumnName = MybatisConfigs.getTenantColumnName(context.getGroupName());
            for (MapperMetadata mapper : mappers) {
                ColumnMetadata tenantColumn = mapper.getEntityMetadata().getColumns().stream().filter(o -> o.getColumn().equalsIgnoreCase(this.tenantColumnName)).findFirst().orElse(null);
                if (tenantColumn == null) continue;
                if (this.tenantPropName == null) {
                    this.tenantPropName = tenantColumn.getProperty();
                }
                if (!this.tableDataPermColumnMappings.containsKey(mapper.getTableName())) {
                    this.tableDataPermColumnMappings.put(mapper.getTableName(), new LinkedHashMap());
                }
                this.tableDataPermColumnMappings.get(mapper.getTableName()).put(this.tenantPropName, this.tenantColumnName);
            }
        }
        StringBuilder logBuilder = new StringBuilder("MENDMIX-TRACE-LOGGGING-->> \nsqlRewrite rules:");
        if (this.columnSharddingTenant) {
            logBuilder.append("\n - tenantSharddingColumn:").append(this.tenantColumnName);
        }
        if (this.deptColumnName != null) {
            logBuilder.append("\n - deptColumnName:").append(this.deptColumnName);
        }
        if (this.ownerColumnName != null) {
            logBuilder.append("\n - createdByColumnName:").append(this.ownerColumnName);
        }
        if (this.softDeleteColumnName != null) {
            logBuilder.append("\n - softDeleteColumn:").append(this.softDeleteColumnName);
        }
        if (this.softDeleteFalseValue != null) {
            logBuilder.append("\n - softDeleteFalseValue:").append(this.softDeleteFalseValue);
        }
        logBuilder.append("\n - globalDataPermColumnMappings:").append(this.globalDataPermColumnMappings);
        logBuilder.append("\n - tableDataPermColumnMappings:").append(this.tableDataPermColumnMappings);
        logger.info(logBuilder.toString());
    }

    private void initColumnConfig(List<MapperMetadata> mappers, String column, List<String> mapperNames) {
        if (column == null) {
            return;
        }
        ArrayList<String> tmpTables = new ArrayList<String>();
        for (MapperMetadata mapper : mappers) {
            ColumnMetadata columnMetadata = mapper.getEntityMetadata().getColumns().stream().filter(o -> o.getColumn().equals(column)).findFirst().orElse(null);
            if (columnMetadata == null) continue;
            if (column.equals(this.softDeleteColumnName)) {
                this.softDeletePropName = columnMetadata.getProperty();
            }
            tmpTables.add(mapper.getTableName());
            if (!this.tableDataPermColumnMappings.containsKey(mapper.getTableName())) {
                this.tableDataPermColumnMappings.put(mapper.getTableName(), new LinkedHashMap());
            }
            this.tableDataPermColumnMappings.get(mapper.getTableName()).put(columnMetadata.getProperty(), column);
        }
        for (MapperMetadata mapper : mappers) {
            if (tmpTables.contains(mapper.getTableName())) {
                mapperNames.add(mapper.getMapperClass().getName());
                continue;
            }
            Set<String> querys = mapper.getQueryTableMappings().keySet();
            block2: for (String query : querys) {
                List<String> tables = mapper.getQueryTableMappings().get(query);
                for (String table : tables) {
                    if (!tmpTables.contains(table)) continue;
                    mapperNames.add(query);
                    continue block2;
                }
            }
        }
    }

    @Override
    public Object onInterceptor(InvocationVals invocation) throws Throwable {
        if (!invocation.isSelect()) {
            return null;
        }
        if (invocation.getMappedStatement().getId().endsWith(CrudMethods.selectByPrimaryKey.name())) {
            return null;
        }
        SqlRewriteStrategy rewriteStrategy = MybatisRuntimeContext.getSqlRewriteStrategy();
        if (rewriteStrategy.isIgnoreAny()) {
            return null;
        }
        if (dynaDataPermEnaled && !rewriteStrategy.isIgnoreColumnPerm()) {
            Map<String, String[]> dataPermValues = MybatisRuntimeContext.getDataPermissionValues();
            invocation.setDataPermValues(dataPermValues);
        }
        this.rewriteSql(invocation, rewriteStrategy);
        if (invocation.getPageParam() != null) {
            return null;
        }
        if (invocation.getSql() == null) {
            String methodName;
            ArrayList<Integer> list = new ArrayList<Integer>(1);
            MapperMetadata entityInfo = MybatisMapperParser.getMapperMetadata(invocation.getMapperNameSpace());
            Class<?> returnType = entityInfo.getMapperMethod(methodName = invocation.getMappedStatement().getId().replace(invocation.getMapperNameSpace(), "").substring(1)).getMethod().getReturnType();
            if (returnType == Integer.TYPE || returnType == Integer.class || returnType == Long.TYPE || returnType == Long.class) {
                list.add(0);
            }
            return list;
        }
        Executor executor = invocation.getExecutor();
        MappedStatement mappedStatement = invocation.getMappedStatement();
        ResultHandler resultHandler = (ResultHandler)invocation.getArgs()[3];
        List parameterMappings = invocation.getBoundSql().getParameterMappings();
        BoundSql newBoundSql = new BoundSql(mappedStatement.getConfiguration(), invocation.getSql(), parameterMappings, invocation.getParameter());
        SqlRewriteHandler.copyForeachAdditionlParams(invocation.getBoundSql(), newBoundSql);
        CacheKey cacheKey = executor.createCacheKey(mappedStatement, invocation.getParameter(), RowBounds.DEFAULT, newBoundSql);
        List resultList = executor.query(mappedStatement, invocation.getParameter(), RowBounds.DEFAULT, resultHandler, cacheKey, newBoundSql);
        return resultList;
    }

    public static void copyForeachAdditionlParams(BoundSql originBoundSql, BoundSql newBoundSql) {
        List parameterMappings = originBoundSql.getParameterMappings();
        int itemIndex = 0;
        for (ParameterMapping parameterMapping : parameterMappings) {
            if (!parameterMapping.getProperty().startsWith(FRCH_PREFIX) || !originBoundSql.hasAdditionalParameter(parameterMapping.getProperty())) continue;
            Object additionalParamVal = originBoundSql.getAdditionalParameter(parameterMapping.getProperty());
            newBoundSql.setAdditionalParameter(parameterMapping.getProperty(), additionalParamVal);
            if (!parameterMapping.getProperty().startsWith(FRCH_ITEM_PREFIX)) continue;
            newBoundSql.setAdditionalParameter(FRCH_INDEX_PREFIX + itemIndex, (Object)itemIndex);
            ++itemIndex;
        }
    }

    private void rewriteSql(InvocationVals invocation, SqlRewriteStrategy rewriteStrategy) {
        String orignSql = invocation.getSql();
        PageParams pageParam = invocation.getPageParam();
        rewriteStrategy.setIgnoreTenant(!this.columnSharddingTenant || rewriteStrategy.isIgnoreTenant());
        Map<String, String[]> dataPermValues = invocation.getDataPermValues();
        if (dataPermValues != null && dataPermValues.containsKey(this.orgBasePermKey) && (this.deptMappedStatements.contains(invocation.getMapperNameSpace()) || this.deptMappedStatements.contains(invocation.getMappedStatement().getId()))) {
            String departmentId = CurrentRuntimeContext.getAndValidateCurrentUser().getDeptId();
            if (StringUtils.isBlank((CharSequence)departmentId)) {
                throw new MendmixBaseException("\u5f53\u524d\u767b\u5f55\u7528\u6237\u90e8\u95e8ID\u4e3a\u7a7a");
            }
            String[] values = dataPermValues.get(this.orgBasePermKey);
            if (values != null && values.length > 0) {
                if ("leaderView".equals(values[0])) {
                    dataPermValues.put(this.deptPropName, new String[]{departmentId + QUERY_FUZZY_CHAR});
                } else {
                    dataPermValues.put(this.deptPropName, new String[]{departmentId});
                }
            } else {
                dataPermValues.put(this.deptPropName, new String[]{departmentId});
            }
        }
        if (pageParam != null) {
            rewriteStrategy.setHandleOrderBy(pageParam.getOrderBys() != null && !pageParam.getOrderBys().isEmpty());
        }
        if (invocation.getDataPermValues() == null && rewriteStrategy.isIgnoreTenant() && rewriteStrategy.isIgnoreSoftDelete() && !rewriteStrategy.isHandleOrderBy()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("_mybatis_sqlRewrite_trace start -> statementId:{},rewriteStrategy:{}", (Object)JsonUtils.toJson((Object)rewriteStrategy));
        }
        SelectBody selectBody = null;
        try {
            Statement stmt = CCJSqlParserUtil.parse((String)orignSql);
            selectBody = ((Select)stmt).getSelectBody();
        }
        catch (JSQLParserException e) {
            logger.error("PARSER_ERROR[" + orignSql + "]", (Throwable)e);
            return;
        }
        this.handleSelectRewrite(selectBody, invocation, rewriteStrategy);
        invocation.setRewriteSql(selectBody.toString());
    }

    private void handleSelectRewrite(SelectBody selectBody, InvocationVals invocation, SqlRewriteStrategy strategy) {
        block10: {
            block8: {
                FromItem fromItem;
                block9: {
                    Map<String, String[]> dataPermValues = invocation.getDataPermValues();
                    if (!(selectBody instanceof PlainSelect)) break block8;
                    PlainSelect select = (PlainSelect)selectBody;
                    fromItem = select.getFromItem();
                    if (!(fromItem instanceof Table)) break block9;
                    Table table = (Table)fromItem;
                    if (!strategy.isAllMatch() && !strategy.hasTableStrategy(table.getName())) {
                        return;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("_mybatis_sqlRewrite_trace processMainTable ->table:{}", (Object)table.getName());
                    }
                    Expression newWhereExpression = this.handleTableDataPermission(select.getWhere(), table, dataPermValues, strategy, false);
                    select.setWhere(newWhereExpression);
                    this.handleTableOrderBy(select, table, invocation);
                    List joins = select.getJoins();
                    if (joins == null) break block10;
                    for (Join join : joins) {
                        if (!(join.getRightItem() instanceof Table)) continue;
                        table = (Table)join.getRightItem();
                        if (logger.isTraceEnabled()) {
                            logger.trace("_mybatis_sqlRewrite_trace processJoinTable ->table:{}", (Object)table.getName());
                        }
                        if (join.isInner()) {
                            newWhereExpression = this.handleTableDataPermission(select.getWhere(), table, dataPermValues, strategy, true);
                            select.setWhere(newWhereExpression);
                            continue;
                        }
                        newWhereExpression = this.handleTableDataPermission(join.getOnExpression(), table, dataPermValues, strategy, true);
                        join.setOnExpression(newWhereExpression);
                    }
                    break block10;
                }
                if (!(fromItem instanceof SubSelect)) break block10;
                SubSelect subSelect = (SubSelect)fromItem;
                this.handleSelectRewrite(subSelect.getSelectBody(), invocation, strategy);
                break block10;
            }
            if (selectBody instanceof SetOperationList) {
                SetOperationList optList = (SetOperationList)selectBody;
                SetOperation operation = (SetOperation)optList.getOperations().get(0);
                if (operation instanceof UnionOp) {
                    // empty if block
                }
                List selects = optList.getSelects();
                for (SelectBody body : selects) {
                    this.handleSelectRewrite(body, invocation, strategy);
                }
            }
        }
    }

    private Expression handleTableDataPermission(Expression whereExpression, Table table, Map<String, String[]> dataMapping, SqlRewriteStrategy strategy, boolean isJoin) {
        AuthUser currentUser;
        boolean handleDataPerm;
        Map<String, String> columnMapping = null;
        boolean bl = handleDataPerm = !isJoin || strategy.isHandleJoin() || strategy.hasTableStrategy(table.getName());
        if (handleDataPerm) {
            String[] columns;
            if (!strategy.isAllMatch() && (columns = strategy.getTableStrategy(table.getName()).columns()).length > 0) {
                columnMapping = new HashMap(columns.length);
                for (String column : columns) {
                    columnMapping.put(this.getDataPermColumnAlias(table.getName(), column), column);
                }
                this.mergeTableColumnMapping(columnMapping, table.getName(), this.tenantPropName, this.softDeletePropName, this.deptPropName);
            }
            if (columnMapping == null) {
                columnMapping = this.tableDataPermColumnMappings.get(table.getName());
            }
        } else {
            columnMapping = new HashMap<String, String>(2);
            this.mergeTableColumnMapping(columnMapping, table.getName(), this.tenantPropName, this.softDeletePropName);
        }
        if (columnMapping == null || columnMapping.isEmpty()) {
            return whereExpression;
        }
        Expression permExpression = null;
        Set fieldNames = columnMapping.keySet();
        boolean withSoftDelete = false;
        boolean withPermission = false;
        String currentTenantId = null;
        for (String fieldName : fieldNames) {
            String[] values;
            String column;
            if (fieldName.equals(this.softDeletePropName)) {
                withSoftDelete = true;
                continue;
            }
            if (!strategy.isIgnoreTenant() && fieldName.equals(this.tenantPropName)) {
                column = this.tenantColumnName;
                currentTenantId = CurrentRuntimeContext.getTenantId();
                if (currentTenantId == null) {
                    throw new MendmixBaseException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u79df\u6237ID");
                }
                values = new String[]{currentTenantId};
            } else {
                if (dataMapping == null || !dataMapping.containsKey(fieldName)) continue;
                column = (String)columnMapping.get(fieldName);
                values = dataMapping.get(fieldName);
                if (!withPermission) {
                    withPermission = true;
                }
            }
            if (values == null || values.length == 0) {
                EqualsTo equalsTo = new EqualsTo();
                equalsTo.setLeftExpression((Expression)new Column(table, column));
                equalsTo.setRightExpression((Expression)new StringValue("__DATA_PERMISSION_NULL__"));
                permExpression = equalsTo;
            } else {
                permExpression = this.handleColumnDataPermCondition(table, permExpression, column, values);
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("_mybatis_sqlRewrite_trace processColumn ->table:{},column:{},addtionalValues:{}", new Object[]{table.getName(), column, values});
        }
        if (withPermission && this.ownerColumnName != null && strategy.handleOwner(table.getName()) && (currentUser = CurrentRuntimeContext.getCurrentUser()) != null) {
            EqualsTo createdByExpr;
            EqualsTo userEquals = new EqualsTo();
            userEquals.setLeftExpression((Expression)new Column(table, this.ownerColumnName));
            userEquals.setRightExpression((Expression)new StringValue(currentUser.getId()));
            if (currentTenantId != null) {
                EqualsTo tenantEquals = new EqualsTo();
                tenantEquals.setLeftExpression((Expression)new Column(table, this.tenantColumnName));
                tenantEquals.setRightExpression((Expression)new StringValue(currentTenantId));
                createdByExpr = new Parenthesis((Expression)new AndExpression((Expression)tenantEquals, (Expression)userEquals));
            } else {
                createdByExpr = userEquals;
            }
            Object object = permExpression = permExpression == null ? createdByExpr : new OrExpression((Expression)new Parenthesis(permExpression), (Expression)createdByExpr);
        }
        if (whereExpression == null) {
            whereExpression = permExpression;
        } else if (permExpression != null) {
            whereExpression = new AndExpression((Expression)new Parenthesis(permExpression), (Expression)new Parenthesis(whereExpression));
        }
        if (withSoftDelete && !strategy.isIgnoreSoftDelete()) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)new Column(table, this.softDeleteColumnName));
            equalsTo.setRightExpression((Expression)new StringValue(this.softDeleteFalseValue));
            whereExpression = whereExpression == null ? equalsTo : new AndExpression((Expression)new Parenthesis(whereExpression), (Expression)equalsTo);
        }
        return whereExpression;
    }

    private Expression handleColumnDataPermCondition(Table table, Expression orginExpression, String columnName, String[] values) {
        Object newExpression = orginExpression;
        Column column = new Column(table, columnName);
        if (values.length == 1) {
            LikeExpression expression;
            if (values[0].endsWith(QUERY_FUZZY_CHAR)) {
                expression = new LikeExpression();
                expression.setLeftExpression((Expression)column);
                expression.setRightExpression((Expression)new StringValue(values[0]));
            } else {
                expression = new EqualsTo();
                expression.setLeftExpression((Expression)column);
                expression.setRightExpression((Expression)new StringValue(values[0]));
            }
            newExpression = orginExpression == null ? expression : (columnName.equalsIgnoreCase(this.softDeleteColumnName) ? new AndExpression(orginExpression, (Expression)expression) : new AndExpression((Expression)expression, orginExpression));
        } else {
            ExpressionList expressionList = new ExpressionList(new ArrayList(values.length));
            for (String value : values) {
                expressionList.getExpressions().add(new StringValue(value));
            }
            InExpression inExpression = new InExpression((Expression)column, (ItemsList)expressionList);
            newExpression = orginExpression == null ? inExpression : new AndExpression(orginExpression, (Expression)inExpression);
        }
        return newExpression;
    }

    private void handleTableOrderBy(PlainSelect selectBody, Table table, InvocationVals invocation) {
        PageParams pageParam = invocation.getPageParam();
        if (pageParam == null || pageParam.getOrderBys() == null || pageParam.getOrderBys().isEmpty()) {
            return;
        }
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>(pageParam.getOrderBys().size());
        for (OrderBy orderBy : pageParam.getOrderBys()) {
            if (orderBy == null) continue;
            MapperMetadata mapperMeta = MybatisMapperParser.getMapperMetadata(invocation.getMapperNameSpace());
            String columnName = mapperMeta.getEntityMetadata().getProp2ColumnMappings().get(orderBy.getField());
            if (columnName == null) {
                columnName = orderBy.getField();
            }
            OrderByElement orderByElement = new OrderByElement();
            orderByElement.setAsc(OrderBy.OrderType.ASC.name().equals(orderBy.getSortType()));
            orderByElement.setExpression((Expression)new Column(table, columnName));
            orderByElements.add(orderByElement);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("_mybatis_sqlRewrite_trace processOrderBy ->table:{},columnName:{}", (Object)table.getName(), (Object)columnName);
        }
        selectBody.setOrderByElements(orderByElements);
    }

    private void mergeTableColumnMapping(Map<String, String> columnMapping, String tableName, String ... propNames) {
        if (!this.tableDataPermColumnMappings.containsKey(tableName)) {
            return;
        }
        LinkedHashMap<String, String> map = this.tableDataPermColumnMappings.get(tableName);
        for (String propName : propNames) {
            if (!map.containsKey(propName)) continue;
            columnMapping.put(propName, map.get(propName));
        }
    }

    private void buildTableDataPermColumnMapping(String tableName, String columnValue) {
        String[] columns;
        if (tableName != null) {
            this.tableDataPermColumnMappings.put(tableName, new LinkedHashMap());
        }
        for (String column : columns = columnValue.split(",|;")) {
            String aliasName;
            String[] tmpArr = column.split(":");
            String string = aliasName = tmpArr.length == 2 ? tmpArr[1] : StringConverter.toCamelCase((String)column);
            if (tableName != null) {
                this.tableDataPermColumnMappings.get(tableName).put(aliasName, tmpArr[0]);
                continue;
            }
            this.globalDataPermColumnMappings.put(aliasName, tmpArr[0]);
            if (this.deptPropName != null || !tmpArr[0].equals(this.deptColumnName)) continue;
            this.deptPropName = aliasName;
        }
    }

    private String getDataPermColumnAlias(String table, String column) {
        String alias = null;
        if (this.tableDataPermColumnMappings.containsKey(table)) {
            alias = this.tableDataPermColumnMappings.get(table).get(column);
        }
        if (alias == null) {
            alias = this.globalDataPermColumnMappings.get(column);
        }
        return StringUtils.defaultString(alias, (String)StringConverter.toCamelCase((String)column));
    }

    @Override
    public void onFinished(InvocationVals invocation, Object result) {
    }

    @Override
    public int interceptorOrder() {
        return 2;
    }

    @Override
    public void close() {
    }
}

