/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin.pagination;

import com.mendmix.common.model.Page;
import com.mendmix.common.model.PageParams;
import com.mendmix.mybatis.MybatisConfigs;
import com.mendmix.mybatis.core.InterceptorHandler;
import com.mendmix.mybatis.datasource.DatabaseType;
import com.mendmix.mybatis.exception.MybatisHanlerInitException;
import com.mendmix.mybatis.metadata.MapperMetadata;
import com.mendmix.mybatis.parser.MybatisMapperParser;
import com.mendmix.mybatis.plugin.InvocationVals;
import com.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import com.mendmix.mybatis.plugin.pagination.PageSqlUtils;
import com.mendmix.mybatis.plugin.rewrite.SqlRewriteHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginationHandler
implements InterceptorHandler {
    private static Logger logger = LoggerFactory.getLogger(PaginationHandler.class);
    private static final String PAGE_COUNT_SUFFIX = "_PageCount";
    public static Map<String, Boolean> pageMappedStatements = new HashMap<String, Boolean>();
    private DatabaseType dbType = DatabaseType.mysql;

    @Override
    public void start(MendmixMybatisInterceptor context) {
        this.dbType = DatabaseType.valueOf(MybatisConfigs.getDbType(context.getGroupName()));
        logger.info("MENDMIX-TRACE-LOGGGING-->> dbType:{}", (Object)this.dbType.name());
        List<MapperMetadata> mappers = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        for (MapperMetadata e : mappers) {
            Method[] methods;
            Class<?> mapperClass = e.getMapperClass();
            for (Method method : methods = mapperClass.getDeclaredMethods()) {
                Class<?> clazz;
                Class<?>[] parameterTypes;
                if (method.getReturnType() != Page.class) continue;
                String msId = e.getMapperClass().getName() + "." + method.getName();
                boolean withPageParams = false;
                Class<?>[] classArray = parameterTypes = method.getParameterTypes();
                int n = classArray.length;
                for (int i = 0; i < n && !(withPageParams = (clazz = classArray[i]) == PageParams.class || clazz.getSuperclass() == PageParams.class); ++i) {
                }
                if (!withPageParams) {
                    throw new MybatisHanlerInitException(String.format("method[%s] returnType is:Page,but not found Parameter[PageParams] in Parameters list", method.getName()));
                }
                pageMappedStatements.put(msId, true);
            }
        }
    }

    @Override
    public Object onInterceptor(InvocationVals invocation) throws Throwable {
        PageParams pageParams = invocation.getPageParam();
        if (pageParams == null) {
            return null;
        }
        MappedStatement orignMappedStatement = invocation.getMappedStatement();
        if (!orignMappedStatement.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            return null;
        }
        if (invocation.getSql() == null) {
            ArrayList<Page> list = new ArrayList<Page>(1);
            list.add(new Page(invocation.getPageParam(), 0L, null));
            return list;
        }
        ResultHandler resultHandler = (ResultHandler)invocation.getArgs()[3];
        Long total = this.executeQueryCount(invocation, resultHandler);
        List datas = this.executeQuery(invocation, resultHandler);
        Page page = new Page(pageParams, total.longValue(), datas);
        ArrayList<Page> list = new ArrayList<Page>(1);
        list.add(page);
        return list;
    }

    private Long executeQueryCount(InvocationVals invocation, ResultHandler resultHandler) throws IllegalAccessException, SQLException {
        MappedStatement countMappedStatement = this.getCountMappedStatement(invocation.getMappedStatement());
        Executor executor = invocation.getExecutor();
        Object parameter = invocation.getParameter();
        BoundSql boundSql = invocation.getBoundSql();
        CacheKey countKey = executor.createCacheKey(countMappedStatement, parameter, RowBounds.DEFAULT, boundSql);
        String countSql = PageSqlUtils.getCountSql(invocation.getSql());
        BoundSql countBoundSql = new BoundSql(countMappedStatement.getConfiguration(), countSql, boundSql.getParameterMappings(), parameter);
        SqlRewriteHandler.copyForeachAdditionlParams(boundSql, countBoundSql);
        List countResultList = executor.query(countMappedStatement, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
        try {
            Long count = (Long)countResultList.get(0);
            return count;
        }
        catch (IndexOutOfBoundsException e) {
            return 0L;
        }
    }

    private List executeQuery(InvocationVals invocation, ResultHandler resultHandler) throws IllegalAccessException, SQLException {
        Executor executor = invocation.getExecutor();
        MappedStatement mappedStatement = invocation.getMappedStatement();
        BoundSql boundSql = invocation.getBoundSql();
        Object parameter = invocation.getParameter();
        String pageSql = PageSqlUtils.getLimitSQL(this.dbType, invocation.getSql(), invocation.getPageParam());
        BoundSql pageBoundSql = new BoundSql(mappedStatement.getConfiguration(), pageSql, boundSql.getParameterMappings(), parameter);
        SqlRewriteHandler.copyForeachAdditionlParams(boundSql, pageBoundSql);
        List resultList = executor.query(mappedStatement, parameter, RowBounds.DEFAULT, resultHandler, null, pageBoundSql);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedStatement getCountMappedStatement(MappedStatement ms) {
        String newMsId = ms.getId() + PAGE_COUNT_SUFFIX;
        MappedStatement statement = null;
        Configuration configuration = ms.getConfiguration();
        try {
            statement = configuration.getMappedStatement(newMsId);
            if (statement != null) {
                return statement;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Configuration configuration2 = configuration;
        synchronized (configuration2) {
            if (configuration.hasStatement(newMsId)) {
                return configuration.getMappedStatement(newMsId);
            }
            MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), newMsId, ms.getSqlSource(), ms.getSqlCommandType());
            builder.resource(ms.getResource());
            builder.fetchSize(ms.getFetchSize());
            builder.statementType(ms.getStatementType());
            builder.keyGenerator(ms.getKeyGenerator());
            if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
                StringBuilder keyProperties = new StringBuilder();
                for (String keyProperty : ms.getKeyProperties()) {
                    keyProperties.append(keyProperty).append(",");
                }
                keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
                builder.keyProperty(keyProperties.toString());
            }
            builder.timeout(ms.getTimeout());
            builder.parameterMap(ms.getParameterMap());
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            String id = newMsId + "-Inline";
            ResultMap resultMap = new ResultMap.Builder(configuration, id, Long.class, new ArrayList(0)).build();
            resultMaps.add(resultMap);
            builder.resultMaps(resultMaps);
            builder.resultSetType(ms.getResultSetType());
            builder.cache(ms.getCache());
            builder.flushCacheRequired(ms.isFlushCacheRequired());
            builder.useCache(ms.isUseCache());
            statement = builder.build();
            configuration.addMappedStatement(statement);
            return statement;
        }
    }

    @Override
    public void onFinished(InvocationVals invocation, Object result) {
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 3;
    }
}

