/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin.pagination;

import com.mendmix.common.model.Page;
import com.mendmix.common.model.PageParams;
import java.util.ArrayList;
import java.util.List;

public class PageExecutor {
    private static ThreadLocal<PageParams> pageParamsHolder = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Page<T> doPagination(PageParams pageParams, PageDataLoader<T> dataLoader) {
        try {
            pageParamsHolder.set(pageParams);
            List<T> list = dataLoader.load();
            Page page = (Page)list.get(0);
            return page;
        }
        finally {
            pageParamsHolder.remove();
        }
    }

    public static <T> Page<T> pagination(PageParams pageParams, PageDataLoader<T> dataLoader) {
        return PageExecutor.doPagination(pageParams, dataLoader);
    }

    public static <E, V> Page<V> pagination(PageParams pageParams, ConvertPageDataLoader<E, V> dataLoader) {
        Page page = PageExecutor.doPagination(pageParams, dataLoader);
        ArrayList<V> convertDatas = new ArrayList<V>(page.getData().size());
        for (Object e : page.getData()) {
            convertDatas.add(dataLoader.convert(e));
        }
        return new Page(pageParams, page.getTotal(), convertDatas);
    }

    public static PageParams getPageParams() {
        return pageParamsHolder.get();
    }

    public static void clearPageParams() {
        pageParamsHolder.remove();
    }

    public static interface ConvertPageDataLoader<E, V>
    extends PageDataLoader<E> {
        public V convert(E var1);
    }

    public static interface PageDataLoader<T> {
        public List<T> load();
    }
}

