/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin.datalog;

import com.mendmix.mybatis.core.BaseEntity;
import com.mendmix.mybatis.core.InterceptorHandler;
import com.mendmix.mybatis.metadata.MapperMetadata;
import com.mendmix.mybatis.parser.MybatisMapperParser;
import com.mendmix.mybatis.plugin.InvocationVals;
import com.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.mapping.MappedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeLogHandler
implements InterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"om.mendmix.mybatis.plugin.datalog");
    private static ThreadLocal<List<String>> entityClassNameHolder = new ThreadLocal();
    private static String[] methodNames = new String[]{"insert", "insertSelective", "selectByPrimaryKey", "deleteByPrimaryKey", "updateByPrimaryKey", "updateByPrimaryKeySelective"};

    public static void set(Class<? extends BaseEntity>[] entityClass) {
        ArrayList<String> names = new ArrayList<String>(entityClass.length);
        for (Class<? extends BaseEntity> clazz : entityClass) {
            MapperMetadata entityInfo = MybatisMapperParser.getMapperMetadata(clazz.getName());
            names.add(entityInfo.getMapperClass().getName());
        }
        entityClassNameHolder.set(names);
    }

    public static void unset() {
        if (entityClassNameHolder.get() == null) {
            return;
        }
        entityClassNameHolder.get().clear();
        entityClassNameHolder.remove();
    }

    @Override
    public void start(MendmixMybatisInterceptor context) {
    }

    @Override
    public Object onInterceptor(InvocationVals invocation) throws Throwable {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onFinished(InvocationVals invocation, Object result) {
        if (entityClassNameHolder.get() == null || entityClassNameHolder.get().isEmpty()) {
            return;
        }
        Object[] args = invocation.getArgs();
        MappedStatement mt = (MappedStatement)args[0];
        String mapperClassName = mt.getId().substring(0, mt.getId().lastIndexOf("."));
        if (!entityClassNameHolder.get().contains(mapperClassName)) {
            return;
        }
        MapperMetadata entityInfo = MybatisMapperParser.getMapperMetadata(mapperClassName);
        if (entityInfo == null) {
            return;
        }
        try {
            System.out.println(mt.getId());
            if (mt.getId().endsWith(methodNames[0]) || mt.getId().endsWith(methodNames[1])) return;
            if (mt.getId().endsWith(methodNames[2])) {
                if (result == null || ((List)result).isEmpty()) return;
                return;
            }
            if (!mt.getId().endsWith(methodNames[3]) && !mt.getId().endsWith(methodNames[4]) && !mt.getId().endsWith(methodNames[5])) return;
        }
        catch (Exception e) {
            logger.warn("MENDMIX-TRACE-LOGGGING-->> datachange_interceptor_error for[" + mt.getId() + "]", (Throwable)e);
        }
    }

    @Override
    public int interceptorOrder() {
        return 9;
    }

    @Override
    public void close() {
    }
}

