/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin.cache;

import com.mendmix.cache.CacheUtils;
import com.mendmix.cache.command.RedisObject;
import com.mendmix.mybatis.core.BaseEntity;
import com.mendmix.mybatis.plugin.cache.CacheHandler;
import java.io.Serializable;
import java.util.concurrent.Callable;

public class EntityCacheHelper {
    public static <T extends BaseEntity> void addCache(T bean, int expireSeconds) {
        String key = EntityCacheHelper.buildCacheKey(bean.getClass(), bean.getId());
        new RedisObject(key).set(bean, (long)expireSeconds);
    }

    public static <T> T queryTryCache(Class<? extends BaseEntity> entityClass, String key, Callable<T> dataCaller) {
        return EntityCacheHelper.queryTryCache(entityClass, key, CacheHandler.defaultCacheExpire, dataCaller);
    }

    public static <T> T queryTryCache(Class<? extends BaseEntity> entityClass, String key, long expireSeconds, Callable<T> dataCaller) {
        String entityClassName = entityClass.getSimpleName();
        key = entityClassName + "." + key;
        Object result = CacheUtils.get((String)key);
        if (result == null) {
            try {
                result = dataCaller.call();
                if (result != null) {
                    CacheUtils.set((String)key, (Object)result, (long)expireSeconds);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)result;
    }

    public static void removeCache(Class<? extends BaseEntity> entityClass, String key) {
        String entityClassName = entityClass.getSimpleName();
        key = entityClassName + "." + key;
        CacheUtils.remove((String[])new String[]{key});
    }

    public static <T extends BaseEntity> void removeCache(T bean) {
        String key = EntityCacheHelper.buildCacheKey(bean.getClass(), bean.getId());
        CacheUtils.remove((String[])new String[]{key});
    }

    public static void removeCache(Class<? extends BaseEntity> entityClass) {
        String entityClassName = entityClass.getSimpleName();
    }

    public static String buildCacheKey(Class<?> entityClass, Serializable id) {
        return entityClass.getSimpleName() + ".id:" + id;
    }
}

