/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin.cache;

import com.mendmix.cache.CacheExpires;
import com.mendmix.cache.CacheUtils;
import com.mendmix.common.CurrentRuntimeContext;
import com.mendmix.common.async.StandardThreadExecutor;
import com.mendmix.common.model.AuthUser;
import com.mendmix.common.util.DigestUtils;
import com.mendmix.common.util.JsonUtils;
import com.mendmix.common.util.ReflectUtils;
import com.mendmix.mybatis.MybatisConfigs;
import com.mendmix.mybatis.MybatisRuntimeContext;
import com.mendmix.mybatis.core.BaseEntity;
import com.mendmix.mybatis.core.InterceptorHandler;
import com.mendmix.mybatis.crud.CrudMethods;
import com.mendmix.mybatis.exception.MybatisHanlerInitException;
import com.mendmix.mybatis.kit.CacheKeyUtils;
import com.mendmix.mybatis.kit.MybatisSqlUtils;
import com.mendmix.mybatis.metadata.MapperMetadata;
import com.mendmix.mybatis.metadata.SqlMetadata;
import com.mendmix.mybatis.parser.MybatisMapperParser;
import com.mendmix.mybatis.plugin.InvocationVals;
import com.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import com.mendmix.mybatis.plugin.cache.QueryCacheMethodMetadata;
import com.mendmix.mybatis.plugin.cache.UpdateByPkCacheMethodMetadata;
import com.mendmix.mybatis.plugin.cache.annotation.Cache;
import com.mendmix.mybatis.plugin.cache.annotation.CacheIgnore;
import com.mendmix.spring.InstanceFactory;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler
implements InterceptorHandler {
    protected static final Logger logger = LoggerFactory.getLogger((String)"com.mendmix.mybatis.plugin.cache");
    public static final String CURRENT_USER_CONTEXT_NAME = "currentUser";
    private static final String BLOCK_ON_CONCURRENT_LOCK_RETURN = "_block_on_concurrentLock";
    public static final String NAME = "cache";
    public static final long IN_1MINS = 60L;
    public static final long IN_1HOUR = 3600L;
    public static long defaultCacheExpire = 0L;
    private static String dataSourceGroupName;
    private static final String STR_PARAM = "param";
    public static final String GROUPKEY_SUFFIX = "~keys";
    private static final String ID_CACHEKEY_JOIN = ".id:";
    private boolean nullValueCache = true;
    public static final String NULL_PLACEHOLDER = "~null";
    private static List<String> groupKeys;
    private static List<String> cacheEnableMappers;
    private static Map<String, Map<String, QueryCacheMethodMetadata>> queryCacheMethods;
    private static Map<String, UpdateByPkCacheMethodMetadata> updatePkCacheMethods;
    private static Map<String, List<String>> customUpdateCacheMapppings;
    private DataSource dataSource;
    private ExecutorService cleanCacheExecutor = Executors.newFixedThreadPool(1, (ThreadFactory)new StandardThreadExecutor.StandardThreadFactory("cleanCacheExecutor"));

    @Override
    public void start(MendmixMybatisInterceptor context) {
        dataSourceGroupName = context.getGroupName();
        Map dataSources = InstanceFactory.getBeansOfType(DataSource.class);
        if (dataSources.size() == 1) {
            this.dataSource = (DataSource)new ArrayList(dataSources.values()).get(0);
        } else {
            for (String beanName : dataSources.keySet()) {
                if (!beanName.startsWith(dataSourceGroupName)) continue;
                this.dataSource = (DataSource)dataSources.get(beanName);
                break;
            }
        }
        defaultCacheExpire = Long.parseLong(MybatisConfigs.getProperty(context.getGroupName(), "mendmix.mybatis.cache.expireSeconds", "0"));
        List<MapperMetadata> mappers = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        Class<BaseEntity> baseEntityClass = BaseEntity.class;
        QueryCacheMethodMetadata methodCache = null;
        for (MapperMetadata mm : mappers) {
            if (mm.getMapperClass().isAnnotationPresent(CacheIgnore.class)) continue;
            if (!baseEntityClass.isAssignableFrom(mm.getEntityClass())) {
                logger.warn("MENDMIX-TRACE-LOGGGING-->> [{}] not extends from [{}],ignore register auto cache!!!!", (Object)mm.getEntityClass().getName(), (Object)baseEntityClass.getName());
                continue;
            }
            Class<?> mapperClass = mm.getMapperClass();
            QueryCacheMethodMetadata queryByPKMethod = this.generateQueryByPKMethod(mapperClass, mm.getEntityClass());
            if (queryByPKMethod == null) continue;
            HashMap<String, QueryCacheMethodMetadata> tmpMap = new HashMap<String, QueryCacheMethodMetadata>();
            tmpMap.put(queryByPKMethod.methodName, queryByPKMethod);
            String keyPatternForPK = queryByPKMethod.keyPattern;
            for (MapperMetadata.MapperMethod method : mm.getMapperMethods().values()) {
                if (!method.getMethod().isAnnotationPresent(Cache.class) || tmpMap.containsKey(method.getFullName())) continue;
                methodCache = this.generateQueryMethodCacheByMethod(mm, method);
                tmpMap.put(method.getFullName(), methodCache);
                logger.info("MENDMIX-TRACE-LOGGGING-->> \u89e3\u6790\u67e5\u8be2\u65b9\u6cd5{}\u81ea\u52a8\u7f13\u5b58\u914d\u7f6e ok,keyPattern:[{}]", (Object)methodCache.methodName, (Object)methodCache.keyPattern);
            }
            cacheEnableMappers.add(mm.getMapperClass().getName());
            logger.info("MENDMIX-TRACE-LOGGGING-->> \u89e3\u6790\u67e5\u8be2\u65b9\u6cd5{}\u81ea\u52a8\u7f13\u5b58\u914d\u7f6e ok,keyPattern:[{}]", (Object)queryByPKMethod.methodName, (Object)queryByPKMethod.keyPattern);
            queryCacheMethods.put(mapperClass.getName(), tmpMap);
            this.generateUpdateByPkCacheMethod(mapperClass, mm.getEntityClass(), keyPatternForPK);
        }
        logger.info("MENDMIX-TRACE-LOGGGING-->> customUpdateCacheMapppings:{}", customUpdateCacheMapppings);
    }

    @Override
    public Object onInterceptor(InvocationVals invocationVal) throws Throwable {
        MappedStatement mt = invocationVal.getMappedStatement();
        boolean getLock = false;
        String cacheKey = null;
        if (mt.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            if (MybatisRuntimeContext.isTransactionalOn()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process skipCache[isTransactionalOn] -> mapperId:{}", (Object)mt.getId());
                }
                return null;
            }
            QueryCacheMethodMetadata metadata = this.getQueryMethodCache(mt.getId());
            if (metadata == null) {
                return null;
            }
            invocationVal.setQueryCacheMetadata(metadata);
            cacheKey = CacheHandler.genarateQueryCacheKey(invocationVal, metadata.keyPattern, invocationVal.getParameter());
            invocationVal.setCacheKey(cacheKey);
            if (!metadata.concurrency) {
                String concurrentLockKey = "concurrent:" + cacheKey;
                invocationVal.setConcurrentLockKey(concurrentLockKey);
                getLock = CacheUtils.setIfAbsent((String)concurrentLockKey, (Object)"1", (long)30L, (TimeUnit)TimeUnit.SECONDS);
                if (!getLock) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process notGetConcurrentLock -> mapperId:{}", (Object)mt.getId());
                    }
                    return BLOCK_ON_CONCURRENT_LOCK_RETURN;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process getConcurrentLock -> mapperId:{}", (Object)mt.getId());
                }
            }
            Object cacheObject = null;
            boolean nullPlaceholder = false;
            if (!metadata.isSecondQueryById()) {
                cacheObject = CacheUtils.get((String)cacheKey);
                boolean bl = nullPlaceholder = this.nullValueCache && NULL_PLACEHOLDER.equals(cacheObject);
                if (StringUtils.isNotBlank((CharSequence)metadata.refKey) && (nullPlaceholder || cacheObject == null)) {
                    cacheObject = CacheUtils.get((String)metadata.refKey);
                    boolean bl2 = nullPlaceholder = this.nullValueCache && NULL_PLACEHOLDER.equals(cacheObject);
                }
                if (nullPlaceholder) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process hitCache -> mapperId:{},cacheKey:{}", (Object)mt.getId(), (Object)cacheKey);
                    }
                } else if (cacheObject != null && logger.isDebugEnabled()) {
                    logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process hitCache -> mapperId:{},cacheKey:{}", (Object)mt.getId(), (Object)cacheKey);
                }
            } else {
                String refCacheKey;
                String string = refCacheKey = this.nullValueCache ? (String)CacheUtils.get((String)cacheKey) : CacheUtils.getStr((String)cacheKey);
                if (refCacheKey != null) {
                    nullPlaceholder = this.nullValueCache && NULL_PLACEHOLDER.equals(refCacheKey);
                    if (nullPlaceholder) {
                        cacheObject = NULL_PLACEHOLDER;
                    } else {
                        cacheObject = CacheUtils.get((String)refCacheKey);
                        if (cacheObject != null && logger.isDebugEnabled()) {
                            logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process  hitRefCache -> mapperId:{},cacheKey:{},refCacheKey:{}", new Object[]{mt.getId(), cacheKey, refCacheKey});
                        }
                    }
                }
            }
            if (nullPlaceholder) {
                cacheObject = new ArrayList(0);
            } else if (cacheObject != null && !(cacheObject instanceof Collection)) {
                cacheObject = Arrays.asList(cacheObject);
            }
            return cacheObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void onFinished(InvocationVals invocationVal, Object result) {
        block31: {
            block34: {
                block35: {
                    block32: {
                        block33: {
                            block29: {
                                block30: {
                                    block27: {
                                        block28: {
                                            block25: {
                                                block26: {
                                                    block23: {
                                                        block24: {
                                                            try {
                                                                if (!"_block_on_concurrentLock".equals(result)) break block23;
                                                                if (invocationVal.getConcurrentLockKey() == null) break block24;
                                                            }
                                                            catch (Throwable var13_17) {
                                                                if (invocationVal.getConcurrentLockKey() != null) {
                                                                    CacheUtils.remove((String[])new String[]{invocationVal.getConcurrentLockKey()});
                                                                }
                                                                throw var13_17;
                                                            }
                                                            CacheUtils.remove((String[])new String[]{invocationVal.getConcurrentLockKey()});
                                                        }
                                                        return;
                                                    }
                                                    mt = invocationVal.getMappedStatement();
                                                    metadata = null;
                                                    if (!mt.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) ** GOTO lbl62
                                                    if (result != null) break block25;
                                                    if (invocationVal.getConcurrentLockKey() == null) break block26;
                                                    CacheUtils.remove((String[])new String[]{invocationVal.getConcurrentLockKey()});
                                                }
                                                return;
                                            }
                                            metadata = invocationVal.getQueryMethodMetadata();
                                            if (metadata != null) break block27;
                                            if (invocationVal.getConcurrentLockKey() == null) break block28;
                                            CacheUtils.remove((String[])new String[]{invocationVal.getConcurrentLockKey()});
                                        }
                                        return;
                                    }
                                    cacheKey = invocationVal.getCacheKey();
                                    if (!(result instanceof List)) ** GOTO lbl44
                                    list = (List)result;
                                    if (!list.isEmpty()) break block29;
                                    if (this.nullValueCache) {
                                        CacheUtils.set((String)cacheKey, (Object)"~null", (long)60L);
                                    }
                                    if (invocationVal.getConcurrentLockKey() == null) break block30;
                                    CacheUtils.remove((String[])new String[]{invocationVal.getConcurrentLockKey()});
                                }
                                return;
                            }
                            v0 = result = metadata.collectionResult != false ? result : list.get(0);
lbl44:
                            // 2 sources

                            if (!metadata.isSecondQueryById()) {
                                CacheUtils.set((String)cacheKey, (Object)result, (long)metadata.getExpire());
                                if (CacheHandler.logger.isDebugEnabled()) {
                                    CacheHandler.logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process addCache -> mapperId:{},cacheKey:{}", (Object)mt.getId(), (Object)cacheKey);
                                }
                                if (metadata.isPk) {
                                    this.cacheUniqueSelectRef(invocationVal, result, mt, cacheKey);
                                } else if (metadata.groupRalated) {
                                    CacheUtils.addStrItemToList((String)metadata.cacheGroupKey, (String)cacheKey);
                                }
                            } else {
                                idCacheKey = CacheHandler.genarateQueryCacheKey(invocationVal, this.getQueryByPkMethodCache((String)mt.getId()).keyPattern, result);
                                if (idCacheKey != null && cacheKey != null) {
                                    if (!CacheUtils.exists((String)idCacheKey)) {
                                        CacheUtils.set((String)idCacheKey, (Object)result, (long)metadata.getExpire());
                                    }
                                    this.cacheFieldRefKey(cacheKey, idCacheKey, metadata.getExpire());
                                    if (CacheHandler.logger.isDebugEnabled()) {
                                        CacheHandler.logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process addCache -> mapperId:{},idCacheKey:{},cacheKey:{}", new Object[]{mt.getId(), idCacheKey, cacheKey});
                                    }
                                }
                            }
                            break block31;
lbl62:
                            // 1 sources

                            mapperClassName = invocationVal.getMapperNameSpace();
                            if (CacheHandler.cacheEnableMappers.contains(mapperClassName) || CacheHandler.customUpdateCacheMapppings.containsKey(mt.getId())) break block32;
                            if (invocationVal.getConcurrentLockKey() == null) break block33;
                            CacheUtils.remove((String[])new String[]{invocationVal.getConcurrentLockKey()});
                        }
                        return;
                    }
                    if (result == null || (Integer)result != 0) break block34;
                    if (invocationVal.getConcurrentLockKey() == null) break block35;
                    CacheUtils.remove((String[])new String[]{invocationVal.getConcurrentLockKey()});
                }
                return;
            }
            if (!mt.getSqlCommandType().equals((Object)SqlCommandType.INSERT)) {
                if (CacheHandler.updatePkCacheMethods.containsKey(mt.getId())) {
                    updateMethodCache = CacheHandler.updatePkCacheMethods.get(mt.getId());
                    idCacheKey = CacheHandler.genarateQueryCacheKey(invocationVal, updateMethodCache.keyPattern, invocationVal.getParameter());
                    CacheUtils.remove((String[])new String[]{idCacheKey});
                } else {
                    mapperMeta = MybatisMapperParser.getMapperMetadata(mapperClassName);
                    parameter = invocationVal.getArgs()[1];
                    boundSql = mt.getBoundSql(parameter);
                    orignSql = boundSql.getSql();
                    idColumn = mapperMeta.getEntityMetadata().getIdColumn();
                    sqlMetadata = MybatisSqlUtils.rewriteAsSelectPkField(orignSql, idColumn.getColumn());
                    tenantId = CurrentRuntimeContext.getTenantId();
                    this.cleanCacheExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (tenantId != null) {
                                CurrentRuntimeContext.setTenantId((String)tenantId);
                            }
                            CacheHandler.this.removeCacheByDyncQuery(mapperMeta, boundSql, sqlMetadata);
                        }
                    });
                }
            }
            this.removeCacheByGroup(mt.getId(), mapperClassName);
            if (!CacheHandler.customUpdateCacheMapppings.containsKey(mt.getId())) break block31;
            this.removeCustomRelateCache(mt.getId());
        }
        if (invocationVal.getConcurrentLockKey() != null) {
            CacheUtils.remove((String[])new String[]{invocationVal.getConcurrentLockKey()});
        }
    }

    private void cacheUniqueSelectRef(InvocationVals invocationVal, Object object, MappedStatement mt, String cacheKey) {
        Collection<QueryCacheMethodMetadata> mcs = queryCacheMethods.get(mt.getId().substring(0, mt.getId().lastIndexOf("."))).values();
        block2: for (QueryCacheMethodMetadata methodCache : mcs) {
            if (!methodCache.isSecondQueryById()) continue;
            try {
                Object[] cacheFieldValues = new Object[methodCache.fieldNames.length];
                for (int i = 0; i < cacheFieldValues.length; ++i) {
                    if (methodCache.fieldNames[i] == null) break block2;
                    cacheFieldValues[i] = ReflectUtils.getObjectValue((Object)object, (String)methodCache.fieldNames[i]);
                    if (cacheFieldValues[i] == null) continue block2;
                }
                String fieldCacheKey = CacheHandler.genarateQueryCacheKey(invocationVal, methodCache.keyPattern, cacheFieldValues);
                this.cacheFieldRefKey(fieldCacheKey, cacheKey, methodCache.getExpire());
                if (!logger.isDebugEnabled()) continue;
                logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process addRefCache -> mapperId:{},cacheKey:{},refkey:{}", new Object[]{mt.getId(), fieldCacheKey, cacheKey});
            }
            catch (Exception e) {
                logger.warn("MENDMIX-TRACE-LOGGGING-->> cacheUniqueSelectRef:" + cacheKey, (Throwable)e);
            }
        }
    }

    private void cacheFieldRefKey(String fieldCacheKey, String idCacheKey, long expired) {
        if (this.nullValueCache) {
            CacheUtils.set((String)fieldCacheKey, (Object)idCacheKey, (long)expired);
        } else {
            CacheUtils.setStr((String)fieldCacheKey, (String)idCacheKey, (long)expired);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCacheByDyncQuery(MapperMetadata mapperMeta, BoundSql boundSql, SqlMetadata sqlMetadata) {
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            this.parseDyncQueryParameters(boundSql, sqlMetadata);
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(sqlMetadata.getSql());
            List<Object> parameters = sqlMetadata.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                statement.setObject(i + 1, parameters.get(i));
            }
            rs = statement.executeQuery();
            ArrayList<String> ids = new ArrayList<String>();
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            if (ids != null && !ids.isEmpty()) {
                List<String> idCacheKeys = ids.stream().map(id -> mapperMeta.getEntityClass().getSimpleName() + ID_CACHEKEY_JOIN + id.toString()).collect(Collectors.toList());
                CacheUtils.remove((String[])idCacheKeys.toArray(new String[0]));
                if (logger.isDebugEnabled()) {
                    logger.debug("remove cacheKeys:{}", idCacheKeys);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String groupName = mapperMeta.getEntityClass().getSimpleName();
            this.clearCacheGroup(groupName, new String[0]);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    private void parseDyncQueryParameters(BoundSql boundSql, SqlMetadata sqlMetadata) throws Exception {
        List parameterMappings = boundSql.getParameterMappings();
        Object parameterObject = boundSql.getParameterObject();
        if (parameterMappings.size() == 1) {
            sqlMetadata.getParameters().add(parameterObject);
        } else {
            Object indexValue = null;
            for (int i = sqlMetadata.getWhereParameterStartIndex(); i <= sqlMetadata.getWhereParameterEndIndex(); ++i) {
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                String property = parameterMapping.getProperty();
                indexValue = property.startsWith("__frch_") ? boundSql.getAdditionalParameter(property) : this.getParameterItemValue(parameterObject, property);
                sqlMetadata.getParameters().add(indexValue);
            }
        }
    }

    private Object getParameterItemValue(Object parameter, String property) throws Exception {
        if (parameter instanceof Map) {
            Map map = (Map)parameter;
            if (!property.contains(".")) {
                return map.get(property);
            }
            String[] subs = StringUtils.split((String)property, (String)".", (int)2);
            return this.getParameterItemValue(map.get(subs[0]), subs[1]);
        }
        return FieldUtils.readDeclaredField((Object)parameter, (String)property, (boolean)true);
    }

    private void removeCacheByGroup(final String msId, String mapperClassName) {
        MapperMetadata entityInfo = MybatisMapperParser.getMapperMetadata(mapperClassName);
        if (entityInfo == null) {
            return;
        }
        final String groupName = entityInfo.getEntityClass().getSimpleName();
        this.cleanCacheExecutor.execute(new Runnable(){

            @Override
            public void run() {
                CacheHandler.this.clearCacheGroup(groupName, new String[0]);
                if (logger.isDebugEnabled()) {
                    logger.debug("MENDMIX-TRACE-LOGGGING-->>  auto_cache_process removeGroupCache -> mapperId:{},groupName:{}", (Object)msId, (Object)groupName);
                }
            }
        });
    }

    private void removeCustomRelateCache(String updateId) {
        final List<String> queryMethods = customUpdateCacheMapppings.get(updateId);
        this.cleanCacheExecutor.execute(new Runnable(){

            @Override
            public void run() {
                for (String method : queryMethods) {
                    QueryCacheMethodMetadata metadata = CacheHandler.this.getQueryMethodCache(method);
                    String prefix = StringUtils.splitByWholeSeparator((String)metadata.keyPattern, (String)"%s")[0];
                    CacheHandler.this.clearCacheGroup(metadata.cacheGroupKey, prefix);
                }
            }
        });
    }

    public static String genarateQueryCacheKey(InvocationVals invocationVal, String keyPattern, Object param) {
        AuthUser currentUser;
        String text;
        try {
            Object[] args;
            if (param instanceof Map) {
                Map map = (Map)param;
                if (map.containsKey("param1")) {
                    args = new String[map.size() / 2];
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = CacheKeyUtils.objcetToString(map.get(STR_PARAM + (i + 1)));
                    }
                } else {
                    args = new String[]{CacheKeyUtils.objcetToString(map)};
                }
            } else {
                Serializable id;
                args = param instanceof BaseEntity ? ((id = ((BaseEntity)param).getId()) != null && !"0".equals(id.toString()) ? new String[]{((BaseEntity)param).getId().toString()} : new String[]{CacheKeyUtils.objcetToString(param)}) : (param instanceof Object[] ? (Object[])param : (param == null ? new Object[]{} : new String[]{CacheKeyUtils.objcetToString(param)}));
            }
            text = StringUtils.join((Object[])args, (String)"_");
        }
        catch (Exception e) {
            text = JsonUtils.toJson((Object)param);
            e.printStackTrace();
        }
        if (text.length() > 64) {
            text = DigestUtils.md5((Object)text);
        }
        String key = String.format(keyPattern, text);
        QueryCacheMethodMetadata methodMetadata = invocationVal.getQueryMethodMetadata();
        if (methodMetadata == null || methodMetadata.isPk || methodMetadata.uniqueIndex) {
            return key;
        }
        StringBuilder sb = new StringBuilder(key);
        String tenantId = CurrentRuntimeContext.getTenantId();
        if (tenantId != null) {
            sb.append("@").append(tenantId);
        }
        if (invocationVal.isDynaDataPermEnaled() && (currentUser = CurrentRuntimeContext.getCurrentUser()) != null) {
            sb.append("@").append(currentUser.getId());
        }
        return sb.toString();
    }

    private QueryCacheMethodMetadata getQueryMethodCache(String mtId) {
        String key1 = mtId.substring(0, mtId.lastIndexOf("."));
        if (queryCacheMethods.containsKey(key1)) {
            return queryCacheMethods.get(key1).get(mtId);
        }
        return null;
    }

    private QueryCacheMethodMetadata getQueryByPkMethodCache(String mtId) {
        if (queryCacheMethods.containsKey(mtId = mtId.substring(0, mtId.lastIndexOf(".")))) {
            return queryCacheMethods.get(mtId).get(mtId + "." + CrudMethods.selectByPrimaryKey.name());
        }
        return null;
    }

    private QueryCacheMethodMetadata generateQueryByPKMethod(Class<?> mapperClass, Class<?> entityClass) {
        Field[] fields;
        QueryCacheMethodMetadata methodCache = null;
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            methodCache = new QueryCacheMethodMetadata();
            methodCache.isPk = true;
            methodCache.collectionResult = false;
            methodCache.keyPattern = entityClass.getSimpleName() + ".id:%s";
            methodCache.methodName = mapperClass.getName() + "." + CrudMethods.selectByPrimaryKey.name();
            methodCache.expire = defaultCacheExpire;
            methodCache.cacheGroupKey = entityClass.getSimpleName() + GROUPKEY_SUFFIX;
            break;
        }
        groupKeys.add(methodCache.cacheGroupKey);
        return methodCache;
    }

    private void generateUpdateByPkCacheMethod(Class<?> mapperClass, Class<?> entityClass, String keyPatternForPK) {
        String methodName = null;
        methodName = mapperClass.getName() + "." + CrudMethods.insert.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(entityClass, methodName, keyPatternForPK, SqlCommandType.INSERT));
        methodName = mapperClass.getName() + "." + CrudMethods.insertSelective.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(entityClass, methodName, keyPatternForPK, SqlCommandType.INSERT));
        methodName = mapperClass.getName() + "." + CrudMethods.updateByPrimaryKey.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(entityClass, methodName, keyPatternForPK, SqlCommandType.UPDATE));
        methodName = mapperClass.getName() + "." + CrudMethods.updateByPrimaryKeySelective.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(entityClass, methodName, keyPatternForPK, SqlCommandType.UPDATE));
        methodName = mapperClass.getName() + "." + CrudMethods.deleteByPrimaryKey.name();
        updatePkCacheMethods.put(methodName, new UpdateByPkCacheMethodMetadata(entityClass, methodName, keyPatternForPK, SqlCommandType.DELETE));
    }

    private QueryCacheMethodMetadata generateQueryMethodCacheByMethod(MapperMetadata mapperMeta, MapperMetadata.MapperMethod mapperMethod) {
        Method method = mapperMethod.getMethod();
        Cache cacheAnnotation = method.getAnnotation(Cache.class);
        String[] evictOnMethods = cacheAnnotation.evictOnMethods();
        Class<?> mapperClass = mapperMeta.getMapperClass();
        Class<?> entityClass = mapperMeta.getEntityClass();
        QueryCacheMethodMetadata methodCache = new QueryCacheMethodMetadata();
        methodCache.methodName = mapperClass.getName() + "." + method.getName();
        methodCache.concurrency = cacheAnnotation.concurrency();
        methodCache.uniqueIndex = cacheAnnotation.uniqueIndex();
        methodCache.cacheGroupKey = entityClass.getSimpleName() + GROUPKEY_SUFFIX;
        if (cacheAnnotation.userScope()) {
            methodCache.contextParam = CURRENT_USER_CONTEXT_NAME;
        } else if (cacheAnnotation.scopeContext().length > 0) {
            methodCache.contextParam = cacheAnnotation.scopeContext()[0];
        }
        if (cacheAnnotation.refKey().length > 0) {
            methodCache.refKey = cacheAnnotation.refKey()[0];
        }
        if (methodCache.contextParam != null && evictOnMethods.length == 0) {
            evictOnMethods = new String[]{"*"};
        }
        boolean bl = methodCache.checkExpired = evictOnMethods.length > 0;
        if (cacheAnnotation.expire() > 0L) {
            methodCache.expire = cacheAnnotation.expire();
        } else if (cacheAnnotation.userScope()) {
            long l = methodCache.expire = 600L < defaultCacheExpire ? 600L : defaultCacheExpire;
        }
        if (methodCache.uniqueIndex && method.getReturnType() != entityClass) {
            throw new MybatisHanlerInitException("@Cache with[uniqueIndex = true] but ReturnType not Match [" + entityClass.getName() + "]");
        }
        boolean bl2 = methodCache.collectionResult = method.getReturnType() == List.class || method.getReturnType() == Set.class;
        methodCache.groupRalated = methodCache.collectionResult ? true : !method.getReturnType().isAnnotationPresent(Table.class);
        methodCache.fieldNames = new String[method.getParameterTypes().length];
        Annotation[][] annotations = method.getParameterAnnotations();
        boolean uniqueQuery = method.getReturnType().isAnnotationPresent(Table.class);
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] aa = annotations[i];
            if (aa.length <= 0) continue;
            String fieldName = null;
            for (Annotation annotation : aa) {
                if (!annotation.toString().contains(Param.class.getName())) continue;
                fieldName = ((Param)annotation).value();
                break;
            }
            if (!uniqueQuery || !mapperMeta.getEntityMetadata().getProp2ColumnMappings().containsKey(fieldName)) continue;
            methodCache.fieldNames[i] = fieldName;
        }
        methodCache.keyPattern = entityClass.getSimpleName() + "." + method.getName() + ":%s";
        if (uniqueQuery) {
            for (String name : methodCache.fieldNames) {
                if (!StringUtils.isBlank((CharSequence)name)) continue;
                methodCache.fieldNames = null;
                break;
            }
        }
        this.buildEvictOnMethods(mapperClass.getName(), mapperMethod, evictOnMethods);
        return methodCache;
    }

    private void buildEvictOnMethods(String mapperClassName, MapperMetadata.MapperMethod method, String[] evictOnMethods) {
        if (evictOnMethods == null || evictOnMethods.length == 0) {
            return;
        }
        String targetMethodFullNamePrefix = mapperClassName.substring(0, mapperClassName.lastIndexOf(".") + 1);
        String targetMapperClassName = null;
        for (String methodName : evictOnMethods) {
            if ("*".equals(methodName)) {
                methodName = mapperClassName + ".*";
            } else if (!methodName.contains(".")) {
                methodName = mapperClassName + "." + methodName;
            }
            if (!methodName.startsWith(targetMethodFullNamePrefix)) {
                methodName = targetMethodFullNamePrefix + methodName;
            }
            targetMapperClassName = methodName.substring(0, methodName.lastIndexOf("."));
            if (!methodName.endsWith("*")) {
                this.addCacheCheckRelations(methodName, method.getFullName());
                continue;
            }
            MapperMetadata methodEntityInfo = MybatisMapperParser.getMapperMetadata(targetMapperClassName);
            if (methodEntityInfo == null) continue;
            for (MapperMetadata.MapperMethod mm : methodEntityInfo.getMapperMethods().values()) {
                if (mm.getSqlType() == SqlCommandType.SELECT || !mm.getFullName().contains(methodName.replace("*", ""))) continue;
                this.addCacheCheckRelations(mm.getFullName(), method.getFullName());
            }
        }
    }

    private void addCacheCheckRelations(String updateMethodName, String queryMethodName) {
        List<String> list = customUpdateCacheMapppings.get(updateMethodName);
        if (list == null) {
            list = new ArrayList<String>();
            customUpdateCacheMapppings.put(updateMethodName, list);
        }
        list.add(queryMethodName);
    }

    public void clearCacheGroup(String groupName, String ... prefixs) {
        int toIndex;
        List<String> keys;
        String cacheGroupKey = groupName.endsWith(GROUPKEY_SUFFIX) ? groupName : groupName + GROUPKEY_SUFFIX;
        int keyCount = (int)CacheUtils.getListSize((String)cacheGroupKey);
        if (keyCount <= 0) {
            return;
        }
        int batchSize = 1000;
        if (keyCount > batchSize) {
            CacheUtils.setExpire((String)cacheGroupKey, (long)CacheExpires.todayEndSeconds());
        }
        boolean withPrefixs = prefixs != null && prefixs.length > 0 && prefixs[0] != null;
        for (int i = 0; i <= keyCount && !(keys = CacheUtils.getStrListItems((String)cacheGroupKey, (int)i, (int)(toIndex = i + batchSize > keyCount ? keyCount : i + batchSize))).isEmpty(); i += batchSize) {
            if (withPrefixs) {
                keys = keys.stream().filter(key -> {
                    for (String prefix : prefixs) {
                        if (!key.contains(prefix)) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
            }
            if (keys.isEmpty()) continue;
            CacheUtils.remove((String[])keys.toArray(new String[0]));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("_clearGroupKey -> group:{},keys:{}", (Object)groupName, (Object)Arrays.toString(keys.toArray()));
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 1;
    }

    static {
        groupKeys = new ArrayList<String>();
        cacheEnableMappers = new ArrayList<String>();
        queryCacheMethods = new HashMap<String, Map<String, QueryCacheMethodMetadata>>();
        updatePkCacheMethods = new HashMap<String, UpdateByPkCacheMethodMetadata>();
        customUpdateCacheMapppings = new HashMap<String, List<String>>();
    }
}

