/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin.autofield;

import com.mendmix.common.CurrentRuntimeContext;
import com.mendmix.common.ThreadLocalContext;
import com.mendmix.common.guid.GUID;
import com.mendmix.mybatis.MybatisConfigs;
import com.mendmix.mybatis.core.BaseEntity;
import com.mendmix.mybatis.core.InterceptorHandler;
import com.mendmix.mybatis.metadata.MapperMetadata;
import com.mendmix.mybatis.parser.MybatisMapperParser;
import com.mendmix.mybatis.plugin.InvocationVals;
import com.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import com.mendmix.mybatis.plugin.autofield.IDGenerator;
import com.mendmix.mybatis.plugin.autofield.annotation.CreatedAt;
import com.mendmix.mybatis.plugin.autofield.annotation.CreatedBy;
import com.mendmix.mybatis.plugin.autofield.annotation.UpdatedAt;
import com.mendmix.mybatis.plugin.autofield.annotation.UpdatedBy;
import com.mendmix.spring.InstanceFactory;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoFieldFillHandler
implements InterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.mendmix.mybatis");
    private static final String INSERT_LIST_METHOD_NAME = "insertList";
    private static final String ATTR_CONTEXT_NAME = "__attr_cxt_name";
    private static final String ATTR_VALUE_CONTEXT_NAME = "__attrval_cxt_name:%s:%s";
    private static Map<String, Field[]> methodFieldMappings = new HashMap<String, Field[]>();
    private IDGenerator idGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDGenerator getIdGenerator() {
        if (this.idGenerator != null) {
            return this.idGenerator;
        }
        Class<AutoFieldFillHandler> clazz = AutoFieldFillHandler.class;
        synchronized (AutoFieldFillHandler.class) {
            this.idGenerator = (IDGenerator)InstanceFactory.getInstance(IDGenerator.class);
            if (this.idGenerator == null) {
                this.idGenerator = new IDGenerator(){

                    @Override
                    public Serializable nextId() {
                        return String.valueOf(GUID.guid());
                    }
                };
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.idGenerator;
        }
    }

    @Override
    public void start(MendmixMybatisInterceptor context) {
        List<MapperMetadata> mappers = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        String tenantColumn = MybatisConfigs.getTenantColumnName(context.getGroupName());
        for (MapperMetadata mm : mappers) {
            Field[] fields;
            Field[] createdFields = new Field[4];
            Field[] updatedFields = new Field[3];
            for (Field field : fields = FieldUtils.getAllFields(mm.getEntityClass())) {
                if (field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(GeneratedValue.class)) {
                    field.setAccessible(true);
                    createdFields[0] = field;
                    continue;
                }
                if (field.isAnnotationPresent(CreatedBy.class)) {
                    field.setAccessible(true);
                    createdFields[1] = field;
                    continue;
                }
                if (field.isAnnotationPresent(CreatedAt.class)) {
                    field.setAccessible(true);
                    createdFields[2] = field;
                    continue;
                }
                if (field.isAnnotationPresent(UpdatedBy.class)) {
                    field.setAccessible(true);
                    updatedFields[1] = field;
                    continue;
                }
                if (field.isAnnotationPresent(UpdatedAt.class)) {
                    field.setAccessible(true);
                    updatedFields[2] = field;
                    continue;
                }
                if (tenantColumn == null) continue;
                boolean isTenantField = field.getName().equals(tenantColumn);
                if (!isTenantField) {
                    Optional<Map.Entry> optional = mm.getPropToColumnMappings().entrySet().stream().filter(e -> ((String)e.getValue()).equalsIgnoreCase(tenantColumn)).findFirst();
                    boolean bl = isTenantField = optional.isPresent() && field.getName().equals(optional.get().getKey());
                }
                if (!isTenantField) continue;
                field.setAccessible(true);
                createdFields[3] = field;
            }
            String keyPrefix = mm.getMapperClass().getName() + ".";
            if (this.hasAnyValue(createdFields)) {
                methodFieldMappings.put(keyPrefix + "insert", createdFields);
                methodFieldMappings.put(keyPrefix + "insertSelective", createdFields);
                methodFieldMappings.put(keyPrefix + INSERT_LIST_METHOD_NAME, createdFields);
            }
            if (!this.hasAnyValue(updatedFields)) continue;
            methodFieldMappings.put(keyPrefix + "updateByPrimaryKey", updatedFields);
            methodFieldMappings.put(keyPrefix + "updateByPrimaryKeySelective", updatedFields);
            methodFieldMappings.put(keyPrefix + "updateByPrimaryKeyWithVersion", updatedFields);
        }
    }

    @Override
    public Object onInterceptor(InvocationVals invocation) throws Throwable {
        if (invocation.isSelect()) {
            return null;
        }
        Object parameter = invocation.getParameter();
        boolean dynaFieldEnabled = ThreadLocalContext.exists((String)ATTR_CONTEXT_NAME);
        if (!dynaFieldEnabled && methodFieldMappings.isEmpty()) {
            return null;
        }
        MappedStatement orignMappedStatement = invocation.getMappedStatement();
        Field[] fields = methodFieldMappings.get(orignMappedStatement.getId());
        if (fields == null) {
            return null;
        }
        boolean updateCommand = SqlCommandType.UPDATE.equals((Object)invocation.getMappedStatement().getSqlCommandType());
        if (orignMappedStatement.getId().endsWith(INSERT_LIST_METHOD_NAME)) {
            if (parameter instanceof Map) {
                try {
                    List list = (List)((Map)parameter).get("arg0");
                    for (Object obj : list) {
                        this.setFieldValue(fields, obj, updateCommand);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.setFieldValue(fields, parameter, updateCommand);
        }
        return null;
    }

    private void setFieldValue(Field[] fields, Object parameter, boolean updateCommand) throws Exception {
        String tmpVal;
        if (fields[0] != null && this.getIdGenerator() != null && this.isNullValue(parameter, fields[0])) {
            Serializable id = this.idGenerator.nextId();
            fields[0].set(parameter, id);
        }
        if (fields[1] != null && (tmpVal = CurrentRuntimeContext.getCurrentUserId()) != null && (updateCommand || this.isNullValue(parameter, fields[1]))) {
            try {
                fields[1].set(parameter, tmpVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fields[2] != null && (updateCommand || this.isNullValue(parameter, fields[2]))) {
            try {
                fields[2].set(parameter, new Date());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fields.length > 3 && fields[3] != null && (tmpVal = CurrentRuntimeContext.getTenantId()) != null && (updateCommand || this.isNullValue(parameter, fields[3]))) {
            fields[3].set(parameter, tmpVal);
        }
        this.setDynaFieldValues(parameter);
    }

    private boolean isNullValue(Object obj, Field field) {
        try {
            Object value = field.get(field);
            return value == null || StringUtils.isBlank((CharSequence)value.toString());
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean hasAnyValue(Field[] fields) {
        for (Field field : fields) {
            if (field == null) continue;
            return true;
        }
        return false;
    }

    public void setFieldValue(Object target, Field field, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private Object readFieldValue(Object target, String fieldName) {
        try {
            Class<?> clazz = target.getClass();
            Field field = FieldUtils.getDeclaredField(clazz, (String)fieldName, (boolean)true);
            while (field == null && clazz.getSuperclass() != null) {
                clazz = clazz.getSuperclass();
                field = FieldUtils.getDeclaredField(clazz, (String)fieldName, (boolean)true);
            }
            if (field == null) {
                return null;
            }
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setDynaFieldValues(Object entity) {
        Map<String, String> dynaValueMap = this.tryGetDynaAttrValues(entity);
        if (dynaValueMap != null) {
            dynaValueMap.forEach((k, v) -> {
                try {
                    FieldUtils.writeDeclaredField((Object)entity, (String)k, (Object)v, (boolean)true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private Map<String, String> tryGetDynaAttrValues(Object parameter) {
        String key;
        Map dynaValueMap;
        if (!(parameter instanceof BaseEntity)) {
            return null;
        }
        Class<?> entityClass = parameter.getClass();
        if (!ThreadLocalContext.exists((String)ATTR_CONTEXT_NAME)) {
            return null;
        }
        Object id = this.readFieldValue(parameter, "id");
        if (id != null && (dynaValueMap = (Map)ThreadLocalContext.get((String)(key = String.format(ATTR_VALUE_CONTEXT_NAME, entityClass.getSimpleName(), id)))) != null) {
            ThreadLocalContext.remove((String[])new String[]{key});
            return dynaValueMap;
        }
        for (int i = 0; i < 10; ++i) {
            key = String.format(ATTR_VALUE_CONTEXT_NAME, entityClass.getSimpleName(), i);
            dynaValueMap = (Map)ThreadLocalContext.get((String)key);
            if (dynaValueMap == null) continue;
            ThreadLocalContext.remove((String[])new String[]{key});
            return dynaValueMap;
        }
        return null;
    }

    @Override
    public void onFinished(InvocationVals invocationVal, Object result) {
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 1;
    }
}

