/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin;

import com.mendmix.mybatis.core.InterceptorHandler;
import com.mendmix.mybatis.plugin.InvocationVals;
import com.mendmix.mybatis.plugin.autofield.AutoFieldFillHandler;
import com.mendmix.mybatis.plugin.cache.CacheHandler;
import com.mendmix.mybatis.plugin.pagination.PaginationHandler;
import com.mendmix.mybatis.plugin.rewrite.SqlRewriteHandler;
import com.mendmix.mybatis.plugin.rwseparate.RwRouteHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MendmixMybatisInterceptor
implements Interceptor,
DisposableBean {
    protected static final Logger logger = LoggerFactory.getLogger((String)"com.mendmix.mybatis");
    private String groupName;
    private List<InterceptorHandler> interceptorHandlers = new ArrayList<InterceptorHandler>();
    private static boolean cacheEnabled;
    private static boolean rwRouteEnabled;

    public MendmixMybatisInterceptor(String groupName, String[] hanlderNames) {
        this.groupName = groupName;
        this.interceptorHandlers.add(new SqlRewriteHandler());
        this.interceptorHandlers.add(new AutoFieldFillHandler());
        this.interceptorHandlers.add(new PaginationHandler());
        this.setInterceptorHandlers(hanlderNames);
    }

    private void setInterceptorHandlers(String[] hanlderNames) {
        for (String name : hanlderNames) {
            if (StringUtils.isBlank((CharSequence)name)) continue;
            if ("cache".equals(name)) {
                this.interceptorHandlers.add(new CacheHandler());
                cacheEnabled = true;
                continue;
            }
            if ("rwRoute".equals(name)) {
                this.interceptorHandlers.add(new RwRouteHandler());
                rwRouteEnabled = true;
                continue;
            }
            try {
                Class<?> clazz = Class.forName(name);
                InterceptorHandler handler = (InterceptorHandler)clazz.newInstance();
                this.interceptorHandlers.add(handler);
                logger.info("MENDMIX-TRACE-LOGGGING-->> registered cumstom InterceptorHandler:{}", (Object)name);
            }
            catch (Exception e) {
                logger.error("MENDMIX-TRACE-LOGGGING-->> registered cumstom InterceptorHandler error", (Throwable)e);
            }
        }
        Collections.sort(this.interceptorHandlers, new Comparator<InterceptorHandler>(){

            @Override
            public int compare(InterceptorHandler o1, InterceptorHandler o2) {
                return Integer.compare(o1.interceptorOrder(), o2.interceptorOrder());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        InvocationVals invocationVal = new InvocationVals(invocation);
        Object result = null;
        boolean cacheHited = false;
        try {
            for (InterceptorHandler handler : this.interceptorHandlers) {
                result = handler.onInterceptor(invocationVal);
                if (result == null) continue;
                cacheHited = handler.getClass() == CacheHandler.class;
                break;
            }
            if (result == null) {
                result = invocation.proceed();
            }
            Iterator<InterceptorHandler> iterator = result;
            return iterator;
        }
        finally {
            for (InterceptorHandler handler : this.interceptorHandlers) {
                if (cacheHited && handler.getClass() == CacheHandler.class) continue;
                try {
                    handler.onFinished(invocationVal, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public void afterRegister() {
        for (InterceptorHandler handler : this.interceptorHandlers) {
            handler.start(this);
        }
    }

    public void destroy() throws Exception {
        for (InterceptorHandler handler : this.interceptorHandlers) {
            handler.close();
        }
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    public static boolean isRwRouteEnabled() {
        return rwRouteEnabled;
    }

    public String getGroupName() {
        return this.groupName;
    }
}

