/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.plugin;

import com.mendmix.common.model.PageParams;
import com.mendmix.mybatis.plugin.cache.QueryCacheMethodMetadata;
import com.mendmix.mybatis.plugin.pagination.PageExecutor;
import com.mendmix.mybatis.plugin.pagination.PaginationHandler;
import java.util.Collection;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Invocation;

public class InvocationVals {
    public static final String DOT = ".";
    private String concurrentLockKey;
    private Executor executor;
    private Object[] args;
    private MappedStatement mappedStatement;
    private Object parameter;
    private BoundSql boundSql;
    private boolean select;
    private String sql;
    private boolean sqlRewrited;
    private Map<String, String[]> dataPermValues;
    private String mapperNameSpace;
    private QueryCacheMethodMetadata queryMethodMetadata;
    private String cacheKey;
    private PageParams pageParam;

    public InvocationVals(Invocation invocation) {
        this.args = invocation.getArgs();
        this.executor = (Executor)invocation.getTarget();
        this.mappedStatement = (MappedStatement)this.args[0];
        this.parameter = this.args[1];
        this.boundSql = this.mappedStatement.getBoundSql(this.parameter);
        this.sql = this.boundSql.getSql();
        this.mapperNameSpace = this.mappedStatement.getId().substring(0, this.mappedStatement.getId().lastIndexOf(DOT));
        this.select = this.mappedStatement.getSqlCommandType().equals((Object)SqlCommandType.SELECT);
        if (this.select) {
            this.pageParam = PageExecutor.getPageParams();
            if (this.pageParam == null && PaginationHandler.pageMappedStatements.containsKey(this.mappedStatement.getId())) {
                if (this.parameter instanceof Map) {
                    Collection parameterValues = ((Map)this.parameter).values();
                    for (Object val : parameterValues) {
                        if (!(val instanceof PageParams)) continue;
                        this.pageParam = (PageParams)val;
                        break;
                    }
                } else {
                    this.pageParam = (PageParams)this.parameter;
                }
            }
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public String getConcurrentLockKey() {
        return this.concurrentLockKey;
    }

    public void setConcurrentLockKey(String concurrentLockKey) {
        this.concurrentLockKey = concurrentLockKey;
    }

    public boolean isSelect() {
        return this.select;
    }

    public String getSql() {
        return this.sql;
    }

    public void setRewriteSql(String sql) {
        this.sql = sql;
        this.sqlRewrited = true;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public MappedStatement getMappedStatement() {
        return this.mappedStatement;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public BoundSql getBoundSql() {
        return this.boundSql;
    }

    public QueryCacheMethodMetadata getQueryMethodMetadata() {
        return this.queryMethodMetadata;
    }

    public void setQueryCacheMetadata(QueryCacheMethodMetadata queryMethodMetadata) {
        this.queryMethodMetadata = queryMethodMetadata;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public String getMapperNameSpace() {
        return this.mapperNameSpace;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public PageParams getPageParam() {
        return this.pageParam;
    }

    public boolean isSqlRewrited() {
        return this.sqlRewrited;
    }

    public Map<String, String[]> getDataPermValues() {
        return this.dataPermValues;
    }

    public void setDataPermValues(Map<String, String[]> dataPermValues) {
        this.dataPermValues = dataPermValues;
    }

    public boolean isDynaDataPermEnaled() {
        return this.dataPermValues != null;
    }
}

