/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.parser;

import com.mendmix.common.util.ResourceUtils;
import com.mendmix.mybatis.datasource.DataSourceConfig;
import com.mendmix.mybatis.metadata.MapperMetadata;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class MybatisMapperParser {
    private static final Logger log = LoggerFactory.getLogger(MybatisMapperParser.class);
    private static Map<String, List<MapperMetadata>> entitiesGroupMap = new HashMap<String, List<MapperMetadata>>();
    private static Map<String, MapperMetadata> mapperKeyMappings = new HashMap<String, MapperMetadata>();

    public static void addMapperLocations(String group, Resource[] mapperLocations) {
        MybatisMapperParser.doParse(group, mapperLocations);
    }

    public static List<MapperMetadata> getMapperMetadatas(String group) {
        return entitiesGroupMap.get(group);
    }

    public static MapperMetadata getMapperMetadata(String mapperOrEntityName) {
        return mapperKeyMappings.get(mapperOrEntityName);
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void doParse(String group, Resource[] mapperLocations) {
        if (entitiesGroupMap.containsKey(group)) {
            return;
        }
        HashMap<String, MapperMetadata> entityInfos = new HashMap<String, MapperMetadata>();
        try {
            void var3_5;
            String string = "";
            if (!DataSourceConfig.DEFAULT_GROUP_NAME.equals(group)) {
                String string2 = "group[" + group + "].";
            }
            List mapperPackages = ResourceUtils.getList((String)((String)var3_5 + "mybatis.mapper-package"));
            for (String mapperPackage : mapperPackages) {
                Resource[] resources;
                String classNameToResourcePath = ClassUtils.convertClassNameToResourcePath((String)mapperPackage);
                String pattern = "classpath*:" + classNameToResourcePath + "/**/*.class";
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                for (Resource res : resources = resolver.getResources(pattern)) {
                    String mapperClass = StringUtils.splitByWholeSeparator((String)res.getURI().getPath(), (String)classNameToResourcePath)[1];
                    mapperClass = mapperPackage + "." + mapperClass.substring(1).substring(0, mapperClass.lastIndexOf(".") - 1);
                    mapperClass = ClassUtils.convertResourcePathToClassName((String)mapperClass);
                    entityInfos.put(mapperClass, new MapperMetadata(mapperClass));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Resource resource : mapperLocations) {
                MybatisMapperParser.parseMapperFile(entityInfos, resource.getFilename(), resource.getInputStream());
            }
        }
        catch (Exception exception) {
            log.error("\u89e3\u6790mapper\u6587\u4ef6\u5f02\u5e38", (Throwable)exception);
            throw new RuntimeException("\u89e3\u6790mapper\u6587\u4ef6\u5f02\u5e38");
        }
        List list = entityInfos.values().stream().filter(e -> e.getEntityClass() != null).collect(Collectors.toList());
        for (MapperMetadata mapperMetadata : list) {
            mapperMetadata.setGroup(group);
        }
        entitiesGroupMap.put(group, list);
        log.info("MENDMIX-TRACE-LOGGGING-->> parse group[{}] finish,size:{}", (Object)group, (Object)entityInfos.size());
    }

    private static void parseMapperFile(Map<String, MapperMetadata> entityInfos, String fileName, InputStream inputStream) throws Exception {
        XPathParser parser = new XPathParser(inputStream, true, null, (EntityResolver)new XMLMapperEntityResolver());
        XNode evalNode = parser.evalNode("/mapper");
        String mapperClass = evalNode.getStringAttribute("namespace");
        MapperMetadata entityInfo = entityInfos.get(mapperClass);
        if (entityInfo == null) {
            entityInfo = new MapperMetadata(mapperClass);
            entityInfos.put(mapperClass, entityInfo);
        }
        if (entityInfo.getEntityClass() == null) {
            log.warn("MENDMIX-TRACE-LOGGGING-->> can't parse entityClass for:{}", (Object)mapperClass);
            return;
        }
        mapperKeyMappings.put(mapperClass, entityInfo);
        mapperKeyMappings.put(entityInfo.getEntityClass().getName(), entityInfo);
        HashMap<String, String> includes = new HashMap<String, String>();
        List children = evalNode.getChildren();
        for (XNode xNode : children) {
            if (!"sql".equalsIgnoreCase(xNode.getName())) continue;
            includes.put(xNode.getStringAttribute("id"), xNode.getStringBody());
        }
        for (XNode xNode : children) {
            if (!"select|insert|update|delete".contains(xNode.getName().toLowerCase())) continue;
            String sql = MybatisMapperParser.parseSql(fileName, xNode, includes);
            entityInfo.addSql(xNode.getName().toLowerCase(), xNode.getStringAttribute("id"), sql);
        }
        inputStream.close();
    }

    private static String parseSql(String fileName, XNode node, Map<String, String> includeContents) {
        StringBuilder sql = new StringBuilder();
        NodeList children = node.getNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XNode child = node.newXNode(children.item(i));
            String data = null;
            if ("#text".equals(child.getName())) {
                data = child.getStringBody("");
            } else if ("include".equals(child.getName())) {
                String refId = child.getStringAttribute("refid");
                data = child.toString();
                if (includeContents.containsKey(refId)) {
                    data = data.replaceAll("<\\s?include.*(" + refId + ").*>", includeContents.get(refId));
                } else {
                    log.error(String.format("MENDMIX-TRACE-LOGGGING-->> Parse SQL from mapper[%s-%s] error,not found include key:%s", fileName, node.getStringAttribute("id"), refId));
                }
            } else {
                data = child.toString();
            }
            data = StringUtils.replaceEach((String)data, (String[])new String[]{"\r", "\n", "\t"}, (String[])new String[]{" ", " ", " "});
            if (!StringUtils.isNotBlank((CharSequence)data)) continue;
            sql.append(data).append("\t").append("\n");
        }
        return sql.toString();
    }

    public static List<String> listFiles(JarFile jarFile, String extensions) {
        if (jarFile == null || StringUtils.isEmpty((CharSequence)extensions)) {
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(extensions)) continue;
            files.add(name);
        }
        return files;
    }

    public static void main(String[] args) {
        String sql = "SELECT <include refid=\"base_fields\" /> dd > FROM users where type = #{type} ";
        System.out.println(sql.replaceAll("<\\s?include.*(base_fields).*>", "xxxx"));
    }
}

