/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.metadata;

import com.mendmix.mybatis.core.BaseEntity;
import com.mendmix.mybatis.metadata.ColumnMetadata;
import com.mendmix.mybatis.metadata.EntityMetadata;
import com.mendmix.mybatis.metadata.TableMetadata;
import com.mendmix.mybatis.plugin.autofield.annotation.CreatedAt;
import com.mendmix.mybatis.plugin.autofield.annotation.CreatedBy;
import com.mendmix.mybatis.plugin.autofield.annotation.UpdatedAt;
import com.mendmix.mybatis.plugin.autofield.annotation.UpdatedBy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang3.StringUtils;

public class MetadataHelper {
    private static final Map<Class<?>, EntityMetadata> tableMapperCache = new HashMap();
    private static final Map<String, Map<String, Field>> entityFieldMappings = new HashMap<String, Map<String, Field>>();
    private static final Map<String, List<ColumnMetadata>> tableColumnMappings = new HashMap<String, List<ColumnMetadata>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityMetadata getEntityMapper(Class<?> entityClass) {
        EntityMetadata entityMeta = tableMapperCache.get(entityClass);
        if (entityMeta != null) {
            return entityMeta;
        }
        Class<?> clazz = entityClass;
        synchronized (clazz) {
            TableMetadata tableMeta = MetadataHelper.getTableMapper(entityClass);
            Class<?> idClass = MetadataHelper.getIdClass(entityClass);
            List<Field> fields = MetadataHelper.getAllField(entityClass);
            HashSet<ColumnMetadata> columnMetas = new HashSet<ColumnMetadata>();
            ColumnMetadata idColumn = null;
            GenerationType idStrategy = null;
            HashMap<String, Field> map = new HashMap<String, Field>();
            for (Field field : fields) {
                if (field.isAnnotationPresent(Transient.class)) continue;
                ColumnMetadata columnMeta = new ColumnMetadata();
                String columnName = null;
                if (field.isAnnotationPresent(Column.class)) {
                    Column column = field.getAnnotation(Column.class);
                    columnName = column.name();
                    columnMeta.setInsertable(column.insertable());
                    columnMeta.setUpdatable(column.updatable());
                }
                columnMeta.setVersionField(field.isAnnotationPresent(Version.class));
                columnMeta.setCreatedByField(field.isAnnotationPresent(CreatedBy.class));
                columnMeta.setCreatedAtField(field.isAnnotationPresent(CreatedAt.class));
                columnMeta.setUpdatedAtField(field.isAnnotationPresent(UpdatedAt.class));
                columnMeta.setUpdatedByField(field.isAnnotationPresent(UpdatedBy.class));
                if (columnMeta.isUpdatable() && (columnMeta.isCreatedAtField() || columnMeta.isCreatedByField())) {
                    columnMeta.setUpdatable(false);
                }
                if (columnName == null || columnName.equals("")) {
                    columnName = MetadataHelper.camelhumpToUnderline(field.getName());
                }
                columnMeta.setProperty(field.getName());
                columnMeta.setColumn(columnName);
                columnMeta.setJavaType(field.getType());
                if (field.isAnnotationPresent(Id.class)) {
                    columnMeta.setId(true);
                    if (field.isAnnotationPresent(GeneratedValue.class)) {
                        idStrategy = field.getAnnotation(GeneratedValue.class).strategy();
                    }
                    idColumn = columnMeta;
                }
                columnMetas.add(columnMeta);
                field.setAccessible(true);
                map.put(field.getName(), field);
            }
            entityFieldMappings.put(tableMeta.getName().toLowerCase(), map);
            if (columnMetas.size() <= 0) {
                throw new RuntimeException("\u5b9e\u4f53" + entityClass.getName() + "\u4e0d\u5b58\u5728\u6620\u5c04\u5b57\u6bb5");
            }
            if (idColumn == null) {
                throw new RuntimeException("\u5b9e\u4f53" + entityClass.getName() + "\u4e0d\u5b58\u5728\u4e3b\u952e");
            }
            entityMeta = new EntityMetadata();
            entityMeta.setTable(tableMeta);
            entityMeta.setColumns(columnMetas);
            entityMeta.setIdClass(idClass);
            entityMeta.setIdColumn(idColumn);
            entityMeta.setIdStrategy(idStrategy);
            tableMapperCache.put(entityClass, entityMeta);
            tableColumnMappings.put(tableMeta.getName().toLowerCase(), new ArrayList<ColumnMetadata>(columnMetas));
            return entityMeta;
        }
    }

    public static List<ColumnMetadata> getTableColumnMappers(String tableName) {
        return tableColumnMappings.get(tableName.toLowerCase());
    }

    private static Class<?> getIdClass(Class<?> entityClass) {
        Type[] genTypes = entityClass.getGenericInterfaces();
        for (int i = 0; i < genTypes.length; ++i) {
            String s2;
            Type genType = genTypes[i];
            String s1 = genType.getClass().getName();
            if (!s1.startsWith(s2 = BaseEntity.class.getName())) continue;
            Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
            Class mapperClass = (Class)params[0];
            return mapperClass;
        }
        return null;
    }

    private static TableMetadata getTableMapper(Class<?> entityClass) {
        TableMetadata tableMapper = new TableMetadata();
        String tableName = null;
        if (entityClass.isAnnotationPresent(Table.class)) {
            Table table = entityClass.getAnnotation(Table.class);
            tableName = StringUtils.isNotBlank((CharSequence)table.name()) ? table.name() : MetadataHelper.camelhumpToUnderline(entityClass.getSimpleName());
        }
        if (StringUtils.isBlank(tableName)) {
            throw new RuntimeException("\u5b9e\u4f53" + entityClass.getName() + "\u4e0d\u5b58\u5728'Table'\u6ce8\u89e3");
        }
        tableMapper.setName(tableName);
        return tableMapper;
    }

    private static String camelhumpToUnderline(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (MetadataHelper.isUppercaseAlpha(c)) {
                sb.append('_').append(c);
                continue;
            }
            sb.append(MetadataHelper.toUpperAscii(c));
        }
        String result = sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
        return result.toLowerCase();
    }

    private static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static char toUpperAscii(char c) {
        if (MetadataHelper.isUppercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    private static List<Field> getAllField(Class<?> entityClass) {
        return MetadataHelper.getAllField(entityClass, null);
    }

    private static List<Field> getAllField(Class<?> entityClass, List<Field> fieldList) {
        Field[] fields;
        if (fieldList == null) {
            fieldList = new ArrayList<Field>();
        }
        if (entityClass.equals(Object.class)) {
            return fieldList;
        }
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldList.add(field);
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (!(superClass == null || superClass.equals(Object.class) || Map.class.isAssignableFrom(superClass) || Collection.class.isAssignableFrom(superClass))) {
            return MetadataHelper.getAllField(entityClass.getSuperclass(), fieldList);
        }
        return fieldList;
    }

    public static Field getEntityField(String tableName, String fieldName) {
        return entityFieldMappings.get(tableName.toLowerCase()).get(fieldName);
    }
}

