/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.metadata;

import com.mendmix.common.model.Page;
import com.mendmix.common.model.PageParams;
import com.mendmix.mybatis.exception.MybatisHanlerInitException;
import com.mendmix.mybatis.kit.MybatisSqlUtils;
import com.mendmix.mybatis.metadata.ColumnMetadata;
import com.mendmix.mybatis.metadata.EntityMetadata;
import com.mendmix.mybatis.metadata.MetadataHelper;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperMetadata {
    private static final Logger log = LoggerFactory.getLogger(MapperMetadata.class);
    private static List<String> queryMethodPrefixs = Arrays.asList("select", "query", "get", "list", "find");
    private String group;
    private String tableName;
    private Class<?> entityClass;
    private Class<?> mapperClass;
    private EntityMetadata entityMetadata;
    private Map<String, String> mapperSqls = new HashMap<String, String>();
    private Map<String, List<String>> queryTableMappings = new HashMap<String, List<String>>();
    private Map<String, String> propToColumnMappings = new HashMap<String, String>();
    private Map<String, MapperMethod> mapperMethods = new HashMap<String, MapperMethod>();

    public MapperMetadata(String mapperClassName) {
        try {
            this.mapperClass = Class.forName(mapperClassName);
            if (!this.mapperClass.isInterface()) {
                return;
            }
            this.parseEntityInfo();
            if (this.entityClass == null) {
                return;
            }
            if (!this.entityClass.isAnnotationPresent(Table.class)) {
                return;
            }
            this.tableName = this.entityClass.getAnnotation(Table.class).name();
            ArrayList<Method> methods = new ArrayList<Method>();
            MapperMetadata.parseAllMethod(this.mapperClass, methods);
            String sql = null;
            for (Method method : methods) {
                Object sqlType;
                String fullName = this.mapperClass.getName() + "." + method.getName();
                if (method.isAnnotationPresent(Select.class)) {
                    sql = method.getAnnotation(Select.class).value()[0];
                    sqlType = SqlCommandType.SELECT;
                } else if (method.isAnnotationPresent(Update.class)) {
                    sql = method.getAnnotation(Update.class).value()[0];
                    sqlType = SqlCommandType.UPDATE;
                } else if (method.isAnnotationPresent(Delete.class)) {
                    sql = method.getAnnotation(Delete.class).value()[0];
                    sqlType = SqlCommandType.DELETE;
                } else if (method.isAnnotationPresent(Insert.class)) {
                    sql = method.getAnnotation(Insert.class).value()[0];
                    sqlType = SqlCommandType.INSERT;
                } else {
                    sqlType = queryMethodPrefixs.stream().anyMatch(e -> method.getName().startsWith((String)e)) ? SqlCommandType.SELECT : null;
                    sql = null;
                }
                if (sql != null) {
                    this.mapperSqls.put(fullName, sql);
                }
                this.mapperMethods.put(method.getName(), new MapperMethod(method, fullName, (SqlCommandType)sqlType));
            }
            List<ColumnMetadata> columns = MetadataHelper.getTableColumnMappers(this.tableName);
            for (ColumnMetadata column : columns) {
                this.propToColumnMappings.put(column.getProperty(), column.getColumn());
            }
        }
        catch (Exception e2) {
            log.info("MENDMIX-TRACE-LOGGGING-->> parse mapper error -> mapperClassName:{}", (Object)mapperClassName, (Object)e2);
        }
    }

    public MapperMetadata(String mapperClassName, String entityClassName, String tableName) {
        this.tableName = tableName;
        try {
            if (StringUtils.isNotBlank((CharSequence)entityClassName)) {
                this.entityClass = Class.forName(entityClassName);
            }
            if (StringUtils.isBlank((CharSequence)this.tableName)) {
                this.tableName = this.entityClass.getAnnotation(Table.class).name();
            }
            this.mapperClass = Class.forName(mapperClassName);
        }
        catch (Exception e) {
            try {
                Type[] types = this.mapperClass.getGenericInterfaces();
                Type[] tempTypes = ((ParameterizedType)types[0]).getActualTypeArguments();
                Class clazz = (Class)tempTypes[0];
                if (clazz != null) {
                    this.entityClass = clazz;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public Class<?> getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(Class<?> mapperClass) {
        this.mapperClass = mapperClass;
    }

    public void addSql(String method, String id, String sql) {
        String fullName = this.mapperClass.getName() + "." + id;
        this.mapperSqls.put(fullName, sql);
        for (MapperMethod mapperMethod : this.mapperMethods.values()) {
            if (!mapperMethod.getFullName().equals(fullName)) continue;
            mapperMethod.sqlType = SqlCommandType.valueOf((String)method.toUpperCase());
            break;
        }
        if (SqlCommandType.SELECT.name().equals(method.toUpperCase())) {
            this.queryTableMappings.put(fullName, MybatisSqlUtils.parseSqlUseTables(sql));
        }
    }

    public Map<String, String> getMapperSqls() {
        return this.mapperSqls;
    }

    public Map<String, MapperMethod> getMapperMethods() {
        return this.mapperMethods;
    }

    public MapperMethod getMapperMethod(String methodFullName) {
        return this.mapperMethods.get(methodFullName);
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public Map<String, List<String>> getQueryTableMappings() {
        return this.queryTableMappings;
    }

    public List<String> getUseTableNames(String msId) {
        return this.queryTableMappings.get(msId);
    }

    public Map<String, String> getPropToColumnMappings() {
        return this.propToColumnMappings;
    }

    public String property2ColumnName(String propName) {
        return this.propToColumnMappings.get(propName);
    }

    private static void parseAllMethod(Class<?> clazz, List<Method> methods) {
        Class<?>[] interfaces;
        if (clazz.getDeclaredMethods() != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                methods.add(method);
            }
        }
        for (Class<?> interClass : interfaces = clazz.getInterfaces()) {
            MapperMetadata.parseAllMethod(interClass, methods);
        }
    }

    private void parseEntityInfo() {
        Type[] interfacesTypes = this.mapperClass.getGenericInterfaces();
        if (interfacesTypes == null || interfacesTypes.length == 0) {
            return;
        }
        Type[] genericTypes = ((ParameterizedType)interfacesTypes[0]).getActualTypeArguments();
        if (genericTypes == null || genericTypes.length == 0) {
            return;
        }
        this.entityClass = (Class)genericTypes[0];
        this.entityMetadata = MetadataHelper.getEntityMapper(this.entityClass);
    }

    public static class MapperMethod {
        Method method;
        String fullName;
        SqlCommandType sqlType;
        boolean pageQuery;

        public MapperMethod(Method method, String fullName, SqlCommandType sqlType) {
            this.method = method;
            this.fullName = fullName;
            this.sqlType = sqlType;
            if (method.getReturnType() == Page.class) {
                Class<?> clazz;
                Class<?>[] parameterTypes;
                boolean withPageParams = false;
                Class<?>[] classArray = parameterTypes = method.getParameterTypes();
                int n = classArray.length;
                for (int i = 0; i < n && !(withPageParams = (clazz = classArray[i]) == PageParams.class || clazz.getSuperclass() == PageParams.class); ++i) {
                }
                if (!withPageParams) {
                    throw new MybatisHanlerInitException(String.format("method[%s] returnType is:Page,but not found Parameter[PageParams] in Parameters list", method.getName()));
                }
                this.pageQuery = true;
            }
        }

        public Method getMethod() {
            return this.method;
        }

        public String getFullName() {
            return this.fullName;
        }

        public SqlCommandType getSqlType() {
            return this.sqlType;
        }

        public boolean isPageQuery() {
            return this.pageQuery;
        }
    }
}

