/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.kit;

import com.mendmix.mybatis.metadata.SqlMetadata;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.SqlCommandType;

public class MybatisSqlUtils {
    private static String mybatisWhereExprEnd = "</where>";
    public static String sqlWherePatternString = "(<|\\s+)WHERE|where(>|\\s+)";
    public static Pattern sqlWherePattern = Pattern.compile(sqlWherePatternString);
    public static final String SQL_PARAMETER_PLACEHOLDER = "?";

    public static String toSelectPkFieldSql(SqlCommandType sqlType, String sql, String idColumnName) {
        sql = sql.trim().replaceAll("\n", " ");
        String selectSql = null;
        StringBuilder sqlBuiler = new StringBuilder().append("SELECT ").append(idColumnName).append(" ");
        if (SqlCommandType.DELETE == sqlType) {
            selectSql = sqlBuiler.append(sql.substring(6)).toString();
        } else if (SqlCommandType.UPDATE == sqlType) {
            String[] segs = sql.split("\\s+", 3);
            sqlBuiler.append(" FROM ").append(segs[1]);
            segs = sqlWherePattern.split(sql, 2);
            if (segs.length == 2) {
                String maybeWhereEnd = segs[1].substring(segs[1].length() - mybatisWhereExprEnd.length()).toLowerCase();
                if (mybatisWhereExprEnd.equals(maybeWhereEnd)) {
                    sqlBuiler.append(" <where>").append(segs[1]);
                } else {
                    sqlBuiler.append(" WHERE ").append(segs[1]);
                }
            }
            selectSql = sqlBuiler.toString();
        }
        return selectSql;
    }

    public static SqlMetadata rewriteAsSelectPkField(String sql, String idColumnName) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            Table table = null;
            Expression where = null;
            int startIndex = 0;
            int endIndex = 0;
            if (statement instanceof Update) {
                Update update = (Update)statement;
                table = update.getTable();
                where = update.getWhere();
                endIndex = startIndex = StringUtils.countMatches((CharSequence)update.getExpressions().toString(), (CharSequence)SQL_PARAMETER_PLACEHOLDER);
            } else if (statement instanceof Delete) {
                Delete delete = (Delete)statement;
                table = delete.getTable();
                where = delete.getWhere();
            } else {
                return null;
            }
            PlainSelect selectBody = new PlainSelect();
            selectBody.setFromItem((FromItem)table);
            SelectExpressionItem selectItem = new SelectExpressionItem((Expression)new Column(idColumnName));
            selectBody.setSelectItems(Arrays.asList(selectItem));
            selectBody.setWhere(where);
            Select select = new Select();
            select.setSelectBody((SelectBody)selectBody);
            String rewriteSql = selectBody.toString();
            while (rewriteSql.contains(SQL_PARAMETER_PLACEHOLDER)) {
                rewriteSql = StringUtils.replaceOnce((String)rewriteSql, (String)SQL_PARAMETER_PLACEHOLDER, (String)"{x}");
                ++endIndex;
            }
            rewriteSql = StringUtils.replace((String)rewriteSql, (String)"{x}", (String)SQL_PARAMETER_PLACEHOLDER);
            return new SqlMetadata(rewriteSql, table.getName(), startIndex, endIndex - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> parseSqlUseTables(String sql) {
        ArrayList<String> tables = new ArrayList<String>(3);
        try {
            String cleanSql = sql.replace("<where>", " where ").replace("<WHERE>", " WHERE ");
            cleanSql = StringUtils.replacePattern((String)cleanSql, (String)"<.*>", (String)" ");
            cleanSql = StringUtils.replacePattern((String)cleanSql, (String)"(\\$|\\#){1}.*\\}", (String)"1").trim();
            if (cleanSql.toLowerCase().endsWith(" where")) {
                cleanSql = cleanSql.substring(0, cleanSql.length() - 5).trim();
            }
            Select select = (Select)CCJSqlParserUtil.parse((String)cleanSql);
            PlainSelect selectBody = (PlainSelect)select.getSelectBody();
            Table table = (Table)selectBody.getFromItem();
            tables.add(table.getName().toLowerCase());
            List joins = selectBody.getJoins();
            if (joins != null) {
                for (Join join : joins) {
                    table = (Table)join.getRightItem();
                    tables.add(table.getName().toLowerCase());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tables;
    }

    public static String underscoreToCamelCase(String para) {
        String[] a;
        if (!para.contains("_")) {
            return para.toLowerCase();
        }
        StringBuilder result = new StringBuilder();
        for (String s : a = para.toLowerCase().split("_")) {
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static void main(String[] args) throws SQLException {
        String sql = "select * from users \t <where>    <if test=\"name != null\">          AND name = #{name}      </if>    <if test=\"mobile != null\">          AND mobile = #{mobile}      </if></where>";
        System.out.println(MybatisSqlUtils.parseSqlUseTables(sql));
    }
}

