/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.datasource;

import com.mendmix.common.GlobalRuntimeContext;
import com.mendmix.common.MendmixBaseException;
import com.mendmix.common.model.RoundRobinSelecter;
import com.mendmix.common.util.BeanUtils;
import com.mendmix.common.util.ResourceUtils;
import com.mendmix.mybatis.MybatisConfigs;
import com.mendmix.mybatis.MybatisRuntimeContext;
import com.mendmix.mybatis.datasource.DataSourceConfig;
import com.mendmix.mybatis.datasource.DataSourceContextVals;
import com.mendmix.mybatis.datasource.DataSourceType;
import com.mendmix.mybatis.datasource.DataSoureConfigHolder;
import com.mendmix.mybatis.datasource.builder.DruidDataSourceBuilder;
import com.mendmix.spring.InstanceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.datasource.AbstractDataSource;

public class MultiRouteDataSource
extends AbstractDataSource
implements ApplicationContextAware,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MultiRouteDataSource.class);
    private DataSourceType dataSourceType = DataSourceType.druid;
    private ApplicationContext context;
    private Map<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
    private String group;
    private boolean dsKeyWithTenant = false;
    private Map<String, RoundRobinSelecter> slaveNumSelecters = new HashMap<String, RoundRobinSelecter>();

    public MultiRouteDataSource() {
        this(DataSourceConfig.DEFAULT_GROUP_NAME);
    }

    public MultiRouteDataSource(String group) {
        this.group = group;
        this.dsKeyWithTenant = MybatisConfigs.isSchameSharddingTenant(group);
    }

    public void afterPropertiesSet() throws Exception {
        List<DataSourceConfig> dsConfigs = DataSoureConfigHolder.getConfigs(this.group);
        for (DataSourceConfig dataSourceConfig : dsConfigs) {
            this.registerRealDataSource(dataSourceConfig);
            if (dataSourceConfig.getTenantId() == null) continue;
            GlobalRuntimeContext.addTenantId((String)dataSourceConfig.getTenantId());
        }
        if (this.targetDataSources == null || this.targetDataSources.isEmpty()) {
            throw new IllegalArgumentException("Property 'targetDataSources' is required");
        }
        logger.info("MENDMIX-TRACE-LOGGGING-->> init multiRouteDataSource[{}] finished -> dsKeyWithTenant:{}", (Object)this.group, (Object)this.dsKeyWithTenant);
    }

    private String currentDataSourceKey() {
        String tenantId;
        DataSourceContextVals context = MybatisRuntimeContext.getDataSourceContextVals();
        boolean useMaster = context.master == null ? true : context.master;
        int index = 0;
        String string = tenantId = this.dsKeyWithTenant ? context.tenantId : null;
        if (this.dsKeyWithTenant && StringUtils.isBlank((CharSequence)tenantId)) {
            throw new MendmixBaseException("Can't get [tentantId] from currentContext");
        }
        if (!useMaster) {
            if (this.slaveNumSelecters.isEmpty()) {
                useMaster = true;
            } else {
                String subGroup;
                String string2 = subGroup = this.dsKeyWithTenant ? this.group + "_" + tenantId : this.group;
                if (!this.slaveNumSelecters.containsKey(subGroup)) {
                    useMaster = true;
                } else {
                    index = this.slaveNumSelecters.get(subGroup).select();
                }
            }
        }
        return DataSourceConfig.buildDataSourceKey(this.group, tenantId, useMaster, index);
    }

    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        return this.determineTargetDataSource().unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance((Object)this) || this.determineTargetDataSource().isWrapperFor(iface);
    }

    protected DataSource determineTargetDataSource() {
        String lookupKey = this.currentDataSourceKey();
        DataSource dataSource = this.targetDataSources.get(lookupKey);
        if (dataSource == null) {
            throw new MendmixBaseException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        InstanceFactory.setApplicationContext((ApplicationContext)this.context);
    }

    private void registerRealDataSource(DataSourceConfig config) throws SQLException {
        config.validate();
        this.mergeGlobalDataSourceConfig(config);
        DataSource dataSource = null;
        if (DataSourceType.druid == this.dataSourceType) {
            dataSource = DruidDataSourceBuilder.builder(config);
        } else if (DataSourceType.hikariCP == this.dataSourceType) {
            // empty if block
        }
        String dsKey = config.dataSourceKey();
        this.targetDataSources.put(dsKey, dataSource);
        if (dsKey.contains("slave")) {
            String subGroup = StringUtils.splitByWholeSeparator((String)dsKey, (String)"_slave")[0];
            if (this.slaveNumSelecters.containsKey(subGroup)) {
                this.slaveNumSelecters.get(subGroup).incrNode();
            } else {
                this.slaveNumSelecters.put(subGroup, new RoundRobinSelecter(1));
            }
        }
        logger.info("MENDMIX-TRACE-LOGGGING-->> register realDataSource[{}] finished! -> config:{}", (Object)config.dataSourceKey(), (Object)config.toString());
    }

    private void mergeGlobalDataSourceConfig(DataSourceConfig config) {
        String groupName = config.getGroup();
        DataSourceConfig globalConfig = (DataSourceConfig)ResourceUtils.getBean((String)"db.", DataSourceConfig.class);
        BeanUtils.copy((Object)globalConfig, (Object)config);
        config.setGroup(groupName);
        if (config.getTestOnBorrow() == null) {
            config.setTestOnBorrow(true);
        }
    }
}

