/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.datasource;

import com.mendmix.common.util.ClassScanner;
import com.mendmix.common.util.ResourceUtils;
import com.mendmix.mybatis.datasource.DataSourceConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DataSoureConfigHolder {
    private static Map<String, List<DataSourceConfig>> allGroupConfigs = new HashMap<String, List<DataSourceConfig>>();

    public static List<String> getGroups() {
        if (allGroupConfigs.isEmpty()) {
            DataSoureConfigHolder.parse();
        }
        return new ArrayList<String>(allGroupConfigs.keySet());
    }

    public static List<DataSourceConfig> getConfigs(String group) {
        if (allGroupConfigs.isEmpty()) {
            DataSoureConfigHolder.parse();
        }
        return allGroupConfigs.get(group);
    }

    public static boolean containsSlaveConfig() {
        if (allGroupConfigs.isEmpty()) {
            DataSoureConfigHolder.parse();
        }
        for (String group : allGroupConfigs.keySet()) {
            if (!allGroupConfigs.get(group).stream().anyMatch(o -> o.getMaster() == false)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTenantConfig(String group) {
        if (allGroupConfigs.isEmpty()) {
            DataSoureConfigHolder.parse();
        }
        return allGroupConfigs.get(group).stream().anyMatch(o -> StringUtils.isNotBlank((CharSequence)o.getTenantId()));
    }

    private static synchronized void parse() {
        Field[] fields;
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : fields = DataSourceConfig.class.getDeclaredFields()) {
            field.setAccessible(true);
            fieldMap.put(field.getName(), field);
        }
        ClassScanner.whoUseMeReport();
        HashMap<String, DataSourceConfig> configs = new HashMap<String, DataSourceConfig>();
        Properties properties = ResourceUtils.getAllProperties((String)".*(\\.db\\.).*", (boolean)false);
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String fieldName;
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            String[] arrays = StringUtils.split((String)key, (String)".");
            DataSourceConfig config = DataSoureConfigHolder.buildDataSourceConfig(arrays);
            String dsKey = config.dataSourceKey();
            if (configs.containsKey(dsKey)) {
                config = (DataSourceConfig)configs.get(dsKey);
            } else {
                configs.put(dsKey, config);
            }
            if (!fieldMap.containsKey(fieldName = arrays[arrays.length - 1])) continue;
            try {
                ((Field)fieldMap.get(fieldName)).set(config, value);
            }
            catch (Exception exception) {}
        }
        Validate.isTrue((!configs.isEmpty() ? 1 : 0) != 0, (String)"Not Any DataSource Config Found", (Object[])new Object[0]);
        for (DataSourceConfig dsConfig : configs.values()) {
            List<DataSourceConfig> groupList = allGroupConfigs.get(dsConfig.getGroup());
            if (groupList == null) {
                groupList = new ArrayList<DataSourceConfig>();
                allGroupConfigs.put(dsConfig.getGroup(), groupList);
            }
            groupList.add(dsConfig);
        }
    }

    private static DataSourceConfig buildDataSourceConfig(String[] arrays) {
        DataSourceConfig config = new DataSourceConfig();
        for (String item : arrays) {
            if (item.startsWith("group")) {
                config.setGroup(DataSoureConfigHolder.parseFieldValue(item));
                continue;
            }
            if (item.startsWith("tenant")) {
                config.setTenantId(DataSoureConfigHolder.parseFieldValue(item));
                continue;
            }
            if (item.startsWith("slave")) {
                String value = DataSoureConfigHolder.parseFieldValue(item);
                if (value != null) {
                    config.setIndex(Integer.parseInt(value));
                }
                config.setMaster(false);
                continue;
            }
            if (!item.equals("master")) continue;
            config.setIndex(0);
            config.setMaster(true);
        }
        return config;
    }

    private static String parseFieldValue(String field) {
        if (!field.contains("[")) {
            return null;
        }
        return StringUtils.split((String)field, (String)"[]")[1];
    }
}

