/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.datasource;

import com.mendmix.common.MendmixBaseException;
import com.mendmix.mybatis.MybatisConfigs;
import org.apache.commons.lang3.StringUtils;

public class DataSourceConfig {
    public static final String SLAVE_KEY = "slave";
    public static final String MASTER_KEY = "master";
    public static String DEFAULT_GROUP_NAME = "default";
    private String group = DEFAULT_GROUP_NAME;
    private String tenantId;
    private String url;
    private String username;
    private String password;
    private Boolean master;
    private Integer index;
    private String driverClassName;
    private Boolean testWhileIdle = true;
    private String validationQuery;
    private Integer maxActive;
    private Integer initialSize;
    private Integer minIdle;
    private Long maxWait;
    private Long minEvictableIdleTimeMillis;
    private Long timeBetweenEvictionRunsMillis;
    private Boolean testOnBorrow = false;
    private Boolean testOnReturn = true;

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getMaster() {
        return this.master;
    }

    public void setMaster(Boolean master) {
        this.master = master;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public Boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(Boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public Long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(Long maxWait) {
        this.maxWait = maxWait;
    }

    public Long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(Long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public Long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(Long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public Boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(Boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public Boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(Boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public String dataSourceKey() {
        return DataSourceConfig.buildDataSourceKey(this.group, this.tenantId, this.master, this.index);
    }

    public void validate() {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.url, this.username, this.password})) {
            throw new MendmixBaseException("DataSourceConfig[url,username,password] is required");
        }
        if (StringUtils.isBlank((CharSequence)this.tenantId) && MybatisConfigs.isSchameSharddingTenant(this.group)) {
            throw new MendmixBaseException("DataSourceConfig[tenantId] is required For SchameSharddingTenant");
        }
    }

    public static String buildDataSourceKey(String group, String tenantId, boolean master, int index) {
        StringBuilder builder = new StringBuilder(group).append("_");
        if (tenantId != null) {
            builder.append(tenantId).append("_");
        }
        builder.append(master ? MASTER_KEY : SLAVE_KEY).append("_");
        builder.append(index);
        return builder.toString();
    }

    public String toString() {
        return "DataSourceConfig [group=" + this.group + ", tenantId=" + this.tenantId + ", url=" + this.url + ", username=" + this.username + ", master=" + this.master + ", index=" + this.index + ", maxActive=" + this.maxActive + "]";
    }
}

