/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.crud.provider;

import com.mendmix.mybatis.crud.builder.AbstractExpressBuilder;
import com.mendmix.mybatis.metadata.ColumnMetadata;
import com.mendmix.mybatis.metadata.EntityMetadata;
import com.mendmix.mybatis.metadata.MetadataHelper;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Set;
import org.apache.ibatis.jdbc.SQL;

public class UpdateWithVersionProvider
extends AbstractExpressBuilder {
    public String updateByPrimaryKeyWithVersion(Object example) throws Exception {
        EntityMetadata entityMapper = MetadataHelper.getEntityMapper(example.getClass());
        Set<ColumnMetadata> columns = entityMapper.getColumns();
        SQL sql = (SQL)new SQL().UPDATE(entityMapper.getTable().getName());
        StringBuilder setBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        ColumnMetadata idColumn = entityMapper.getIdColumn();
        this.appendWhere(whereBuilder, idColumn);
        for (ColumnMetadata column : columns) {
            Object value;
            if (column.isId() || !column.isUpdatable() || (value = MetadataHelper.getEntityField(entityMapper.getTable().getName(), column.getProperty()).get(example)) == null) continue;
            if (column.isVersionField()) {
                this.appendWhere(whereBuilder, column);
                value = this.getNewVersionVal(column.getJavaType(), value);
                this.appendUpdateSet(setBuilder, column, value);
                continue;
            }
            this.appendUpdateSet(setBuilder, column);
        }
        sql.SET(setBuilder.toString());
        sql.WHERE(whereBuilder.toString());
        return sql.toString();
    }

    private Object getNewVersionVal(Class<?> clazz, Object originalVersionVal) {
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return (Long)originalVersionVal + 1L;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return (Integer)originalVersionVal + 1;
        }
        if (Date.class.equals(clazz)) {
            return new Date();
        }
        if (Timestamp.class.equals(clazz)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (LocalDateTime.class.equals(clazz)) {
            return LocalDateTime.now();
        }
        return originalVersionVal;
    }
}

