/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.crud.builder;

import com.mendmix.mybatis.crud.SqlTemplate;
import com.mendmix.mybatis.crud.builder.AbstractMethodBuilder;
import com.mendmix.mybatis.metadata.ColumnMetadata;
import com.mendmix.mybatis.metadata.EntityMetadata;
import com.mendmix.mybatis.metadata.TableMetadata;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;

public class UpdateBuilder
extends AbstractMethodBuilder {
    @Override
    SqlCommandType sqlCommandType() {
        return SqlCommandType.UPDATE;
    }

    @Override
    String[] methodNames() {
        return new String[]{"updateByPrimaryKey", "updateByPrimaryKeySelective"};
    }

    @Override
    String buildSQL(EntityMetadata entityMapper, boolean selective) {
        TableMetadata tableMapper = entityMapper.getTable();
        Set<ColumnMetadata> columnMappers = entityMapper.getColumns();
        String idColumn = null;
        String idProperty = null;
        StringBuilder set = new StringBuilder();
        set.append("<trim prefix=\"SET\" suffixOverrides=\",\">");
        for (ColumnMetadata column : columnMappers) {
            if (!column.isUpdatable()) continue;
            if (column.isId()) {
                idColumn = column.getColumn();
                idProperty = column.getProperty();
                continue;
            }
            String expr = SqlTemplate.wrapIfTag(column.getProperty(), column.getColumn() + "=#{" + column.getProperty() + "}", !selective);
            set.append(expr);
            if (selective) continue;
            set.append(",");
        }
        if (!selective) {
            set.deleteCharAt(set.length() - 1);
        }
        set.append("</trim>");
        String sql = String.format("UPDATE %s %s \n WHERE %s = #{%s}", tableMapper.getName(), set.toString(), idColumn, idProperty);
        return sql;
    }

    @Override
    void setResultType(Configuration configuration, MappedStatement statement, Class<?> entityClass) {
    }

    @Override
    boolean scriptWrapper() {
        return true;
    }
}

