/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.crud.builder;

import com.mendmix.mybatis.crud.SqlTemplate;
import com.mendmix.mybatis.crud.builder.AbstractMethodBuilder;
import com.mendmix.mybatis.metadata.ColumnMetadata;
import com.mendmix.mybatis.metadata.EntityMetadata;
import com.mendmix.mybatis.metadata.TableMetadata;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;

public class InsertListBuilder
extends AbstractMethodBuilder {
    @Override
    SqlCommandType sqlCommandType() {
        return SqlCommandType.INSERT;
    }

    @Override
    String[] methodNames() {
        return new String[]{"insertList"};
    }

    @Override
    String buildSQL(EntityMetadata entityMapper, boolean selective) {
        TableMetadata table = entityMapper.getTable();
        Set<ColumnMetadata> columns = entityMapper.getColumns();
        StringBuilder fieldBuilder = new StringBuilder("(");
        StringBuilder prppertyBuilder = new StringBuilder("(");
        if (!entityMapper.autoId()) {
            fieldBuilder.append(entityMapper.getIdColumn().getColumn()).append(",");
            prppertyBuilder.append("#{item.").append(entityMapper.getIdColumn().getProperty()).append("},");
        }
        for (ColumnMetadata column : columns) {
            if (column.isId() || !column.isInsertable()) continue;
            String fieldExpr = SqlTemplate.wrapIfTag(column.getProperty(), column.getColumn(), true);
            String propertyExpr = SqlTemplate.wrapIfTag(column.getProperty(), "#{item." + column.getProperty() + "}", true);
            fieldBuilder.append(fieldExpr);
            fieldBuilder.append(",");
            prppertyBuilder.append(propertyExpr);
            prppertyBuilder.append(",");
        }
        fieldBuilder.deleteCharAt(fieldBuilder.length() - 1);
        prppertyBuilder.deleteCharAt(prppertyBuilder.length() - 1);
        fieldBuilder.append(")");
        prppertyBuilder.append(")");
        String sql = String.format("INSERT INTO %s \n %s \n VALUES \n <foreach collection=\"list\" item=\"item\" index=\"index\" separator=\",\">%s</foreach>", table.getName(), fieldBuilder.toString(), prppertyBuilder.toString());
        return sql;
    }

    @Override
    void setResultType(Configuration configuration, MappedStatement statement, Class<?> entityClass) {
    }

    @Override
    boolean scriptWrapper() {
        return true;
    }
}

