/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.crud.builder;

import com.mendmix.mybatis.crud.builder.AbstractExpressBuilder;
import com.mendmix.mybatis.metadata.EntityMetadata;
import com.mendmix.mybatis.metadata.MapperMetadata;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public abstract class AbstractMethodBuilder
extends AbstractExpressBuilder {
    public void build(Configuration configuration, LanguageDriver languageDriver, MapperMetadata mapperMeta) {
        for (String name : this.methodNames()) {
            String msId = mapperMeta.getMapperClass().getName() + "." + name;
            EntityMetadata entityMapper = mapperMeta.getEntityMetadata();
            boolean selective = this.selective() ? this.selective() : name.endsWith("Selective");
            String sql = this.buildSQL(entityMapper, selective);
            if (this.scriptWrapper()) {
                sql = String.format("<script>%s</script>", sql);
            }
            SqlSource sqlSource = languageDriver.createSqlSource(configuration, sql, mapperMeta.getEntityClass());
            MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, msId, sqlSource, this.sqlCommandType());
            if (this.sqlCommandType() == SqlCommandType.INSERT) {
                Jdbc3KeyGenerator keyGenerator = entityMapper.autoId() ? new Jdbc3KeyGenerator() : new NoKeyGenerator();
                statementBuilder.keyGenerator((KeyGenerator)keyGenerator).keyProperty(entityMapper.getIdColumn().getProperty()).keyColumn(entityMapper.getIdColumn().getColumn());
            }
            MappedStatement statement = statementBuilder.build();
            this.setResultType(configuration, statement, mapperMeta.getEntityClass());
            configuration.addMappedStatement(statement);
        }
    }

    protected boolean selective() {
        return false;
    }

    abstract SqlCommandType sqlCommandType();

    abstract String[] methodNames();

    abstract String buildSQL(EntityMetadata var1, boolean var2);

    abstract boolean scriptWrapper();

    abstract void setResultType(Configuration var1, MappedStatement var2, Class<?> var3);
}

