/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.crud.builder;

import com.mendmix.common.util.DateUtils;
import com.mendmix.mybatis.metadata.ColumnMetadata;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractExpressBuilder {
    protected StringBuilder appendWhere(StringBuilder whereBuilder, ColumnMetadata column) {
        if (whereBuilder.length() > 0) {
            whereBuilder.append(" AND ");
        }
        whereBuilder.append(column.getColumn()).append("=");
        whereBuilder.append("#{").append(column.getProperty()).append("}");
        return whereBuilder;
    }

    protected StringBuilder appendWhere(StringBuilder whereBuilder, ColumnMetadata column, Object value) {
        if (whereBuilder.length() > 0) {
            whereBuilder.append(" AND ");
        }
        whereBuilder.append(column.getColumn()).append("=");
        if (column.getJavaType() == String.class) {
            whereBuilder.append("'").append(value).append("'");
        } else if (column.getJavaType() == Date.class) {
            whereBuilder.append("'").append(DateUtils.format((Date)((Date)value), (String[])new String[0])).append("'");
        } else if (column.getJavaType() == Boolean.class || column.getJavaType() == Boolean.TYPE) {
            if (StringUtils.isNumeric((CharSequence)value.toString())) {
                whereBuilder.append(value);
            } else {
                whereBuilder.append((Boolean)value != false ? 1 : 0);
            }
        } else {
            whereBuilder.append(value);
        }
        return whereBuilder;
    }

    protected StringBuilder appendUpdateSet(StringBuilder setBuilder, ColumnMetadata column) {
        if (setBuilder.length() > 0) {
            setBuilder.append(",");
        }
        setBuilder.append(column.getColumn()).append("=");
        setBuilder.append("#{").append(column.getProperty()).append("}");
        return setBuilder;
    }

    protected StringBuilder appendUpdateSet(StringBuilder setBuilder, ColumnMetadata column, Object value) {
        if (setBuilder.length() > 0) {
            setBuilder.append(",");
        }
        setBuilder.append(column.getColumn()).append("=");
        if (column.getJavaType() == String.class) {
            setBuilder.append("'").append(value).append("'");
        } else if (column.getJavaType() == Date.class) {
            setBuilder.append("'").append(DateUtils.format((Date)((Date)value), (String[])new String[0])).append("'");
        } else if (column.getJavaType() == Boolean.class || column.getJavaType() == Boolean.TYPE) {
            setBuilder.append((Boolean)value != false ? 1 : 0);
        } else {
            setBuilder.append(value);
        }
        return setBuilder;
    }
}

