/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis.crud;

import com.mendmix.mybatis.crud.builder.BatchUpdateByPrimaryKeysBuilder;
import com.mendmix.mybatis.crud.builder.CountAllBuilder;
import com.mendmix.mybatis.crud.builder.DeleteByPrimaryKeyBuilder;
import com.mendmix.mybatis.crud.builder.InsertBuilder;
import com.mendmix.mybatis.crud.builder.InsertListBuilder;
import com.mendmix.mybatis.crud.builder.SelectAllBuilder;
import com.mendmix.mybatis.crud.builder.SelectByPrimaryKeyBuilder;
import com.mendmix.mybatis.crud.builder.SelectByPrimaryKeysBuilder;
import com.mendmix.mybatis.crud.builder.UpdateBuilder;
import com.mendmix.mybatis.metadata.MapperMetadata;
import com.mendmix.mybatis.parser.MybatisMapperParser;
import java.util.List;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(GeneralSqlGenerator.class);
    private LanguageDriver languageDriver;
    private Configuration configuration;
    private String group;

    public GeneralSqlGenerator(String group, Configuration configuration) {
        this.group = group;
        this.configuration = configuration;
        this.languageDriver = configuration.getDefaultScriptingLanguageInstance();
    }

    public void generate() {
        if (this.languageDriver == null) {
            this.languageDriver = this.configuration.getDefaultScriptingLanguageInstance();
        }
        List<MapperMetadata> mappers = MybatisMapperParser.getMapperMetadatas(this.group);
        for (MapperMetadata entity : mappers) {
            entity.setGroup(this.group);
            new InsertBuilder().build(this.configuration, this.languageDriver, entity);
            new InsertListBuilder().build(this.configuration, this.languageDriver, entity);
            new DeleteByPrimaryKeyBuilder().build(this.configuration, this.languageDriver, entity);
            new UpdateBuilder().build(this.configuration, this.languageDriver, entity);
            new SelectAllBuilder().build(this.configuration, this.languageDriver, entity);
            new SelectByPrimaryKeyBuilder().build(this.configuration, this.languageDriver, entity);
            new SelectByPrimaryKeysBuilder().build(this.configuration, this.languageDriver, entity);
            new CountAllBuilder().build(this.configuration, this.languageDriver, entity);
            new BatchUpdateByPrimaryKeysBuilder().build(this.configuration, this.languageDriver, entity);
            log.info("MENDMIX-TRACE-LOGGGING-->> generate autoCrud for:[{}] finish", (Object)entity.getEntityClass().getName());
        }
    }
}

