/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis;

import com.mendmix.common.CurrentRuntimeContext;
import com.mendmix.common.ThreadLocalContext;
import com.mendmix.common.model.AuthUser;
import com.mendmix.mybatis.MybatisConfigs;
import com.mendmix.mybatis.datasource.DataSourceContextVals;
import com.mendmix.mybatis.plugin.rewrite.DataPermissionItem;
import com.mendmix.mybatis.plugin.rewrite.SqlRewriteStrategy;
import com.mendmix.mybatis.plugin.rewrite.UserPermissionProvider;
import com.mendmix.mybatis.plugin.rewrite.annotation.DataPermission;
import com.mendmix.spring.InstanceFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MybatisRuntimeContext {
    private static final String CONTEXT_TRANS_ON_KEY = "_ctx_trans_on_";
    private static final String CONTEXT_FORCE_MASTER_KEY = "_ctx_force_master_";
    private static final String CONTEXT_DATASOURCE_KEY = "_ctx_ds_";
    private static final String CONTEXT_DATA_PROFILE_KEY = "_ctx_dataprofile_";
    private static final String CONTEXT_REWRITE_STRATEGY = "_ctx_rewrite_strategy_";
    private static UserPermissionProvider userPermissionProvider = (UserPermissionProvider)InstanceFactory.getInstance(UserPermissionProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UserPermissionProvider getUserPermissionProvider() {
        if (userPermissionProvider != null) {
            return userPermissionProvider;
        }
        Class<MybatisRuntimeContext> clazz = MybatisRuntimeContext.class;
        synchronized (MybatisRuntimeContext.class) {
            if (userPermissionProvider != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return userPermissionProvider;
            }
            userPermissionProvider = (UserPermissionProvider)InstanceFactory.getInstance(UserPermissionProvider.class);
            if (userPermissionProvider == null) {
                userPermissionProvider = new UserPermissionProvider(){

                    @Override
                    public List<DataPermissionItem> findUserPermissions(String userId) {
                        return null;
                    }
                };
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return userPermissionProvider;
        }
    }

    public static String getContextParam(String paramName) {
        if (StringUtils.isBlank((CharSequence)paramName)) {
            return null;
        }
        if ("currentUser".equals(paramName)) {
            AuthUser currentUser = CurrentRuntimeContext.getCurrentUser();
            return currentUser == null ? null : currentUser.getName();
        }
        return ThreadLocalContext.getStringValue((String)paramName);
    }

    public static void setContextParam(String name, String value) {
        ThreadLocalContext.set((String)name, (Object)value);
    }

    public static void setTransactionalMode(boolean on) {
        ThreadLocalContext.set((String)CONTEXT_TRANS_ON_KEY, (Object)String.valueOf(on));
        if (on) {
            MybatisRuntimeContext.forceUseMaster();
        }
    }

    public static String getTransactionalMode() {
        return ThreadLocalContext.getStringValue((String)CONTEXT_TRANS_ON_KEY);
    }

    public static boolean isTransactionalOn() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_TRANS_ON_KEY));
    }

    public static void setIgnoreSqlRewrite(boolean ignore) {
        MybatisRuntimeContext.getSqlRewriteStrategy().setIgnoreAny(ignore);
    }

    public static void setIgnoreTenant(boolean ignore) {
        MybatisRuntimeContext.getSqlRewriteStrategy().setIgnoreTenant(ignore);
    }

    public static void setIgnoreSoftDeleteConditon(boolean ignore) {
        MybatisRuntimeContext.getSqlRewriteStrategy().setIgnoreSoftDelete(ignore);
    }

    public static void setDataPermissionStrategy(DataPermission annotation) {
        MybatisRuntimeContext.getSqlRewriteStrategy().setDataPermission(annotation);
    }

    public static SqlRewriteStrategy getSqlRewriteStrategy() {
        SqlRewriteStrategy strategy = (SqlRewriteStrategy)ThreadLocalContext.get((String)CONTEXT_REWRITE_STRATEGY);
        if (strategy == null) {
            strategy = new SqlRewriteStrategy(MybatisConfigs.DATA_PERM_ALL_MATCH_MODE_ENABLED, null);
            ThreadLocalContext.set((String)CONTEXT_REWRITE_STRATEGY, (Object)strategy);
        }
        return strategy;
    }

    public static boolean isEmpty() {
        return ThreadLocalContext.isEmpty();
    }

    public static void forceUseMaster() {
        ThreadLocalContext.set((String)CONTEXT_FORCE_MASTER_KEY, (Object)String.valueOf(true));
    }

    public static boolean isForceUseMaster() {
        return Boolean.parseBoolean(ThreadLocalContext.getStringValue((String)CONTEXT_TRANS_ON_KEY));
    }

    public static void useSlave() {
        DataSourceContextVals vals = MybatisRuntimeContext.getDataSourceContextVals();
        vals.master = false;
    }

    public static void useMaster() {
        DataSourceContextVals vals = MybatisRuntimeContext.getDataSourceContextVals();
        vals.master = true;
    }

    public static boolean isUseMaster() {
        Boolean master = MybatisRuntimeContext.getDataSourceContextVals().master;
        return master == null ? true : master;
    }

    public static DataSourceContextVals getDataSourceContextVals() {
        DataSourceContextVals dataSourceContextVals = (DataSourceContextVals)ThreadLocalContext.get((String)CONTEXT_DATASOURCE_KEY);
        if (dataSourceContextVals == null) {
            dataSourceContextVals = new DataSourceContextVals();
            dataSourceContextVals.tenantId = CurrentRuntimeContext.getTenantId();
            ThreadLocalContext.set((String)CONTEXT_DATASOURCE_KEY, (Object)dataSourceContextVals);
        }
        return dataSourceContextVals;
    }

    public static void addDataPermissionValues(String fieldName, String ... fieldValues) {
        Map<String, String[]> map = MybatisRuntimeContext.getDataPermissionValues();
        if (map == null) {
            map = new HashMap<String, String[]>(5);
            ThreadLocalContext.set((String)CONTEXT_DATA_PROFILE_KEY, map);
        }
        map.put(fieldName, fieldValues);
    }

    public static Map<String, String[]> getDataPermissionValues() {
        Map valueMaps = (Map)ThreadLocalContext.get((String)CONTEXT_DATA_PROFILE_KEY);
        if (valueMaps == null) {
            AuthUser currentUser = CurrentRuntimeContext.getCurrentUser();
            if (currentUser == null) {
                return null;
            }
            List<DataPermissionItem> permissions = MybatisRuntimeContext.getUserPermissionProvider().findUserPermissions(currentUser.getId());
            if (permissions == null) {
                return null;
            }
            for (DataPermissionItem item : permissions) {
                if (item.isAllMatch()) continue;
                if (item.getValues() == null || item.getValues().isEmpty()) {
                    MybatisRuntimeContext.addDataPermissionValues(item.getFieldName(), new String[0]);
                    continue;
                }
                MybatisRuntimeContext.addDataPermissionValues(item.getFieldName(), item.getValues().toArray(new String[0]));
            }
        }
        return valueMaps;
    }
}

