/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.mybatis;

import com.mendmix.common.util.ResourceUtils;
import com.mendmix.mybatis.datasource.DataSourceConfig;
import com.mendmix.mybatis.datasource.DataSoureConfigHolder;
import com.mendmix.mybatis.datasource.DatabaseType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class MybatisConfigs {
    public static final String DB_TYPE = "mendmix.dbType";
    public static final String CACHE_ENABLED = "mendmix.mybatis.cache.enabled";
    public static final String CACHE_EXPIRE_SECONDS = "mendmix.mybatis.cache.expireSeconds";
    public static final String TENANT_ENABLED = "mendmix.mybatis.tenant.enabled";
    public static final String TENANT_IGNORE_USER_TYPE = "mendmix.mybatis.tenant.ignoreUserType";
    public static final String TENANT_COLUMN_NAME = "mendmix.mybatis.tenant.columnName";
    public static final String INTERCEPTOR_HANDLERCLASS = "mendmix.mybatis.interceptorHandlerClass";
    public static final String SOFT_DELETE_COLUMN_NAME = "mendmix.mybatis.softDelete.columnName";
    public static final String SOFT_DELETE_FALSE_VALUE = "mendmix.mybatis.softDelete.falseValue";
    public static final String OWNER_COLUMN_NAME = "mendmix.mybatis.createBy.columnName";
    public static final String DEPT_COLUMN_NAME = "mendmix.mybatis.department.columnName";
    public static final String ORG_BASE_PERM_KEY = "mendmix.mybatis.currentOrgPermKey";
    public static final boolean DATA_PERM_ALL_MATCH_MODE_ENABLED = ResourceUtils.getBoolean((String)"application.mybatis.dataPermssion.allMatchMode.enabled", (boolean)true);
    private static Map<String, Properties> groupProperties = new HashMap<String, Properties>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String group, String key, String defaultValue) {
        if (!groupProperties.containsKey(group)) {
            Map<String, Properties> map = groupProperties;
            synchronized (map) {
                String prefix = DataSourceConfig.DEFAULT_GROUP_NAME.equals(group) ? "mendmix.mybatis" : group + ".mendmix.mybatis";
                MybatisConfigs.addProperties(group, ResourceUtils.getAllProperties((String)prefix));
            }
        }
        return groupProperties.get(group).getProperty(key, defaultValue);
    }

    private static void addProperties(String group, Properties properties) {
        if (!DataSourceConfig.DEFAULT_GROUP_NAME.equals(group)) {
            String prefix = group + ".";
            Properties _properties = new Properties();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (v != null) {
                    _properties.put(k.toString().replace(prefix, ""), v);
                }
            }));
            properties = _properties;
        }
        groupProperties.put(group, properties);
    }

    public static boolean getBoolean(String group, String key, boolean defaultValue) {
        return Boolean.parseBoolean(MybatisConfigs.getProperty(group, key, String.valueOf(defaultValue)));
    }

    public static String getDbType(String group) {
        return MybatisConfigs.getProperty(group, DB_TYPE, DatabaseType.mysql.name()).toLowerCase();
    }

    public static boolean isCacheEnabled(String group) {
        return MybatisConfigs.getBoolean(group, CACHE_ENABLED, false);
    }

    public static String getTenantColumnName(String group) {
        return MybatisConfigs.getProperty(group, TENANT_COLUMN_NAME, null);
    }

    public static String getSoftDeleteColumn(String group) {
        return MybatisConfigs.getProperty(group, SOFT_DELETE_COLUMN_NAME, null);
    }

    public static String getSoftDeletedFalseValue(String group) {
        return MybatisConfigs.getProperty(group, SOFT_DELETE_FALSE_VALUE, "0");
    }

    public static String getCurrentOrgPermKey(String group) {
        return MybatisConfigs.getProperty(group, ORG_BASE_PERM_KEY, "organization");
    }

    public static String getOwnerColumnName(String group) {
        return MybatisConfigs.getProperty(group, OWNER_COLUMN_NAME, null);
    }

    public static String getDeptColumnName(String group) {
        return MybatisConfigs.getProperty(group, DEPT_COLUMN_NAME, null);
    }

    public static boolean isColumnSharddingTenant(String group) {
        return MybatisConfigs.getBoolean(group, TENANT_ENABLED, false);
    }

    public static boolean isDataPermissionEnabled(String group) {
        return MybatisConfigs.getBoolean(group, "mendmix.mybatis.dataPermission.enabled", false);
    }

    public static boolean isSchameSharddingTenant(String group) {
        return DataSoureConfigHolder.containsTenantConfig(group);
    }

    public static String[] getHandlerNames(String group) {
        ArrayList<String> hanlders = new ArrayList<String>();
        String customHandlers = MybatisConfigs.getProperty(group, INTERCEPTOR_HANDLERCLASS, null);
        if (!StringUtils.isBlank((CharSequence)customHandlers)) {
            String[] customHanlderClass = org.springframework.util.StringUtils.tokenizeToStringArray((String)customHandlers, (String)",; \t\n");
            hanlders.addAll(Arrays.asList(customHanlderClass));
        }
        if (MybatisConfigs.isCacheEnabled(group)) {
            hanlders.add("cache");
        }
        if (DataSoureConfigHolder.containsSlaveConfig()) {
            hanlders.add("rwRoute");
        }
        return hanlders.toArray(new String[0]);
    }
}

